% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmajs.R
\name{sigmajs}
\alias{sigmajs}
\title{Initialise}
\usage{
sigmajs(
  type = NULL,
  width = "100\%",
  kill = FALSE,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{type}{Renderer type, one of \code{canvas}, \code{webgl} or \code{svg}.}

\item{width, height}{Dimensions of graph.}

\item{kill}{Whether to kill the graph, set to \code{FALSE} 
if using \code{\link{sigmajsProxy}}, else set to \code{TRUE}. Only useful in Shiny.}

\item{elementId}{Id of elment.}
}
\value{
An object of class \code{htmlwidget} which renders the visualisation on print.
}
\description{
Initialise a graph.
}
\note{
Keep \code{width} at \code{100\%} for a responsive visualisation.
}
\examples{
nodes <- sg_make_nodes()
edges <- sg_make_edges(nodes)

sigmajs("svg") \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\%
  sg_edges(edges, id, source, target) 

}
\seealso{
\code{\link{sg_kill}}.
}
