% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Aneuploidy_score.R
\name{get_Aneuploidy_score}
\alias{get_Aneuploidy_score}
\title{Get Aneuploidy Score from Copy Number Profile}
\usage{
get_Aneuploidy_score(
  data,
  ploidy_df = NULL,
  genome_build = "hg19",
  rm_black_arms = FALSE
)
}
\arguments{
\item{data}{a CopyNumber object or a \code{data.frame} containing at least
'chromosome', 'start', 'end', 'segVal', 'sample' these columns.}

\item{ploidy_df}{default is \code{NULL}, compute ploidy by segment-size weighted copy number
aross autosome, see \link{get_cn_ploidy}. You can also provide a \code{data.frame} with 'sample'
and 'ploidy' columns.}

\item{genome_build}{genome build version, should be 'hg19', 'hg38', 'mm9' or 'mm10'.}

\item{rm_black_arms}{if \code{TRUE}, remove short arms of chr13/14/15/21/22 from calculation
as documented in reference #3.}
}
\value{
A \code{data.frame}
}
\description{
This implements a Cohen-Sharir method (see reference) like "Aneuploidy Score" computation.
You can read the source code to see how it works. Basically, it follows
the logic of Cohen-Sharir method but with some difference in detail implementation.
Their results should be counterpart, but with no data validation for now.
\strong{Please raise an issue if you find problem/bugs in this function}.
}
\examples{
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))

df <- get_Aneuploidy_score(cn)
df

df2 <- get_Aneuploidy_score(cn@data)
df2

df3 <- get_Aneuploidy_score(cn@data,
  ploidy_df = get_cn_ploidy(cn@data)
)
df3
}
\references{
\itemize{
\item Cohen-Sharir, Y., McFarland, J. M., Abdusamad, M., Marquis, C., Bernhard, S. V., Kazachkova, M., ... & Ben-David, U. (2021). Aneuploidy renders cancer cells vulnerable to mitotic checkpoint inhibition. Nature, 1-6.
\item Logic reference: \url{https://github.com/quevedor2/aneuploidy_score/}.
\item Taylor, Alison M., et al. "Genomic and functional approaches to understanding cancer aneuploidy." Cancer cell 33.4 (2018): 676-689.
}
}
