% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_fit_bootstrap.R
\name{sig_fit_bootstrap}
\alias{sig_fit_bootstrap}
\title{Obtain Bootstrap Distribution of Signature Exposures of a Certain Tumor Sample}
\usage{
sig_fit_bootstrap(
  catalog,
  sig,
  n = 100L,
  sig_index = NULL,
  sig_db = "legacy",
  db_type = c("", "human-exome", "human-genome"),
  show_index = TRUE,
  method = c("QP", "NNLS", "SA"),
  auto_reduce = FALSE,
  SA_not_bootstrap = FALSE,
  type = c("absolute", "relative"),
  rel_threshold = 0,
  mode = c("SBS", "DBS", "ID", "copynumber"),
  find_suboptimal = FALSE,
  suboptimal_ref_error = NULL,
  suboptimal_factor = 1.05,
  ...
)
}
\arguments{
\item{catalog}{a named numeric vector or a numeric matrix with dimension Nx1.
N is the number of component, 1 is the sample.}

\item{sig}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract},
or just a raw signature matrix/\code{data.frame} with row representing components (motifs) and
column representing signatures.}

\item{n}{the number of bootstrap replicates.}

\item{sig_index}{a vector for signature index. "ALL" for all signatures.}

\item{sig_db}{default 'legacy', it can be 'legacy' (for \href{https://cancer.sanger.ac.uk/cosmic/signatures_v2.tt/}{COSMIC v2 'SBS'}),
'SBS', 'DBS', 'ID' and 'TSB' (for \href{https://cancer.sanger.ac.uk/cosmic/signatures/}{COSMIV v3.1 signatures})
for small scale mutations.
For more specific details, it can also be 'SBS_hg19', 'SBS_hg38',
'SBS_mm9', 'SBS_mm10', 'DBS_hg19', 'DBS_hg38', 'DBS_mm9', 'DBS_mm10' to use
COSMIC v3 reference signatures from Alexandrov, Ludmil B., et al. (2020) (reference #1).
In addition, it can be one of "SBS_Nik_lab_Organ", "RS_Nik_lab_Organ",
"SBS_Nik_lab", "RS_Nik_lab" to refer reference signatures from
Degasperi, Andrea, et al. (2020) (reference #2);
"RS_BRCA560", "RS_USARC" to reference signatures from BRCA560 and USARC cohorts;
"CNS_USARC" (40 categories), "CNS_TCGA" (48 categories) to reference copy number signatures from USARC cohort and TCGA;
"CNS_TCGA176" (176 categories) and "CNS_PCAWG176" (176 categories) to reference copy number signatures from PCAWG and TCGA separately.
\strong{UPDATE}, the latest version of reference version can be automatically
downloaded and loaded from \url{https://cancer.sanger.ac.uk/signatures/downloads/}
when a option with \code{latest_} prefix is specified (e.g. "latest_SBS_GRCh37").
\strong{Note}: the signature profile for different genome builds are basically same.
And specific database (e.g. 'SBS_mm10') contains less signatures than all COSMIC
signatures (because some signatures are not detected from Alexandrov, Ludmil B., et al. (2020)).
For all available options, check the parameter setting.}

\item{db_type}{only used when \code{sig_db} is enabled.
"" for keeping default, "human-exome" for transforming to exome frequency of component,
and "human-genome" for transforming to whole genome frequency of component.
Currently only works for 'SBS'.}

\item{show_index}{if \code{TRUE}, show valid indices.}

\item{method}{method to solve the minimazation problem.
'NNLS' for non-negative least square; 'QP' for quadratic programming; 'SA' for simulated annealing.}

\item{auto_reduce}{if \code{TRUE}, try reducing the input reference signatures to increase
the cosine similarity of reconstructed profile to observed profile.}

\item{SA_not_bootstrap}{if \code{TRUE}, directly run 'SA' multiple times with original input instead of
bootstrap samples.}

\item{type}{'absolute' for signature exposure and 'relative' for signature relative exposure.}

\item{rel_threshold}{numeric vector, a signature with relative exposure
lower than (equal is included, i.e. \code{<=}) this value will be set to 0
(both absolute exposure and relative exposure).
In this case, sum of signature contribution may not equal to 1.}

\item{mode}{signature type for plotting, now supports 'copynumber', 'SBS',
'DBS', 'ID' and 'RS' (genome rearrangement signature).}

\item{find_suboptimal}{logical, if \code{TRUE}, find suboptimal decomposition with
slightly higher error than the optimal solution by method 'SA'. This is useful
to explore hidden dependencies between signatures. More see reference.}

\item{suboptimal_ref_error}{baseline error used for finding suboptimal solution.
if it is \code{NULL}, then use 'SA' method to obtain the optimal error.}

\item{suboptimal_factor}{suboptimal factor to get suboptimal error, default is \code{1.05},
i.e., suboptimal error is \code{1.05} times baseline error.}

\item{...}{control parameters passing to argument \code{control} in \code{GenSA} function when use method 'SA'.}
}
\value{
a \code{list}
}
\description{
This can be used to obtain the confidence of signature exposures or search
the suboptimal decomposition solution.
}
\examples{

# This function is designed for processing
# one sample, thus is not very useful in practice
# please check `sig_fit_bootstrap_batch`

# For general purpose -------------------
W <- matrix(c(1, 2, 3, 4, 5, 6), ncol = 2)
colnames(W) <- c("sig1", "sig2")
W <- apply(W, 2, function(x) x / sum(x))

H <- matrix(c(2, 5, 3, 6, 1, 9, 1, 2), ncol = 4)
colnames(H) <- paste0("samp", 1:4)

V <- W \%*\% H
V

if (requireNamespace("quadprog", quietly = TRUE)) {
  H_bootstrap <- sig_fit_bootstrap(V[, 1], W, n = 10, type = "absolute")
  ## Typically, you have to run many times to get close to the answer
  boxplot(t(H_bootstrap$expo))
  H[, 1]

  ## Return P values
  ## In practice, run times >= 100
  ## is recommended
  report_bootstrap_p_value(H_bootstrap)
  ## For multiple samples
  ## Input a list
  report_bootstrap_p_value(list(samp1 = H_bootstrap, samp2 = H_bootstrap))

  #   ## Find suboptimal decomposition
  #   H_suboptimal <- sig_fit_bootstrap(V[, 1], W,
  #     n = 10,
  #     type = "absolute",
  #     method = "SA",
  #     find_suboptimal = TRUE
  #   )
}
}
\references{
Huang X, Wojtowicz D, Przytycka TM. Detecting presence of mutational signatures in cancer with confidence. Bioinformatics. 2018;34(2):330–337. doi:10.1093/bioinformatics/btx604
}
\seealso{
\link{report_bootstrap_p_value}, \link{sig_fit}, \link{sig_fit_bootstrap_batch}
}
\keyword{bootstrap}
