% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_drop_model.R
\name{sample_drop_model}
\alias{sample_drop_model}
\title{Sample drop model(s) with parameters according to priors}
\usage{
sample_drop_model(
  number_of_contributors,
  sampling_parameters,
  drop_in_rate = 0,
  model_settings
)
}
\arguments{
\item{number_of_contributors}{Integer}

\item{sampling_parameters}{List. Needs to contain:
\itemize{
\item min_dropout_probability. Numeric of length one.
\item max_dropout_probability Numeric of length one.
}}

\item{drop_in_rate}{Numeric vector of length one. Expected number of drop-ins per locus. Default is 0.}

\item{model_settings}{List. See \link{drop_model}.}
}
\value{
When \code{length(number_of_contributors)==1}, a single \link{drop_model} of class \code{pg_model}. Otherwise, a list of these.
}
\description{
Sample drop model(s) with parameters according to priors
}
\details{
In simulation studies involving many mixed DNA profiles, one often needs to generate various samples with different model parameters. This function samples a drop model with parameters according to prior distributions. The dropout probability for each contributor is sampled uniformly between \code{min_dropout_probability.} and \code{max_dropout_probability}.
}
\examples{
gf <- gf_configuration()

sampling_parameters <- list(min_dropout_probability. = 0., max_dropout_probability. = 0.5)

model <- sample_drop_model(number_of_contributors = 1,
                           sampling_parameters = sampling_parameters,
                           model_settings = list(locus_names = gf$autosomal_markers,
                           size_regression = gf$size_regression))
}
\seealso{
\link{sample_mixtures_fixed_parameters} to directly supply parameters of choice for more control
}
