% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effDisc-helper.R
\name{effDisc-helper}
\alias{effDisc-helper}
\alias{matchTol}
\alias{support}
\title{Helper functions for discrete effectiveness distributions}
\usage{
matchTol(x, support, tol = 1e-04)

support(measure, runLength = 1000)
}
\arguments{
\item{x}{a vector of effectiveness scores.}

\item{support}{the support of the distribution.}

\item{tol}{tolerance for matching.}

\item{measure}{the case insensitive name of the effectiveness measure. See Details.}

\item{runLength}{the maximum number of documents retrieved for a query (defautls to 1000).}
}
\value{
\code{matchTol}: an integer vector giving the position in the support of the match if
  there is a match, otherwise \code{NA}.

  \code{support}: the support of the distribution of scores defined by the measure.
}
\description{
These are functions to help in the creation and use of discrete effectiveness distributions.
}
\details{
\code{matchTol} returns a vector of the positions of matches of \code{x} in the vector of
possible support values, within tolerance (see \code{\link[base]{match}}). This is helpful when
data are loaded from disk and possibly rounded or truncated.

\code{support} obtains the discrete support defined by an effectiveness measure given its name.
Current measures are Reciprocal Rank (\code{"RR"}), and Precision at k (\code{"P@k"} or
\code{"Pk"}, where \code{k} is the cutoff, eg. \code{"P@10"} or \code{"P10"}).
}
\examples{
support("rr")
support("rr", runLength = 10)
support("p@10")
support("p20")

(i <- matchTol(c(.1, .4, .41, .40001), support("p10")))
support("p10")[i]
}
\seealso{
\code{\link[=eff.disc-class]{eff.disc}}.
}
