% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibVars.R
\name{calibVars}
\alias{calibVars}
\title{Construct a matrix of binary variables for calibration}
\usage{
calibVars(x)
}
\arguments{
\item{x}{a vector that can be interpreted as factor, or a matrix or
\code{data.frame} consisting of such variables.}
}
\value{
A matrix of binary variables that indicate membership to the
corresponding factor levels.
}
\description{
Construct a matrix of binary variables for calibration of sample weights
according to known marginal population totals. The following methods
are implemented:
\itemize{
\item \code{calibVars.default(x)}
\item \code{calibVars.matrix(x)}
\item \code{calibVars.matrix(x)}
\item \code{calibVars.data.frame(x)}
}
}
\examples{
data(eusilcS)
# default method
\dontrun{
aux <- calibVars(eusilcS$rb090)
head(aux)
# data.frame method
aux <- calibVars(eusilcS[, c("db040", "rb090")])
head(aux)
}
}
\references{
M. Templ, B. Meindl, A. Kowarik, A. Alfons, O. Dupriez (2017) Simulation of Synthetic Populations for Survey Data Considering Auxiliary
Information. \emph{Journal of Statistical Survey}, \strong{79} (10), 1--38. doi: 10.18637/jss.v079.i10
}
\seealso{
\code{\link{calibSample}}
}
\author{
Bernhard Meindl and Andreas Alfons
}
\keyword{survey}
