% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_from_pedigree_allchr.R
\name{sim_from_pedigree_allchr}
\alias{sim_from_pedigree_allchr}
\title{Simulate genotypes for pedigree for multiple chromosomes}
\usage{
sim_from_pedigree_allchr(
  pedigree,
  map,
  m = 10,
  p = 0,
  obligate_chiasma = FALSE
)
}
\arguments{
\item{pedigree}{Matrix or data frame describing a pedigree, with first four
columns being individual ID, mom ID, dad ID, and sex (female as
\code{0}, male as \code{1}).}

\item{map}{marker locations, a list with elements for each
chromosome}

\item{m}{Crossover interference parameter, for chi-square model
(m=0 corresponds to no interference).}

\item{p}{proportion of crossovers coming from no-interference process}

\item{obligate_chiasma}{If TRUE, require an obligate chiasma on the
4-strand bundle at meiosis.}
}
\value{
A list with each component being the result from
\code{sim_from_pedigree}, of length same as \code{map}.
}
\description{
Simulate genotypes along all chromosomes for a pedigree. This is a
wrap up of sim_from_pedigree.
}
\examples{
library(qtl)
# marker map
map <- sim.map(len=rep(100, 19), n.mar=10, include.x=FALSE)
# simulate AIL pedigree
tab <- sim_ail_pedigree(12, 30)
# simulate data from that pedigree
dat <- sim_from_pedigree_allchr(tab, map)

}
\seealso{
\code{\link[=check_pedigree]{check_pedigree()}},
\code{\link[=sim_ril_pedigree]{sim_ril_pedigree()}}, \code{\link[=sim_ail_pedigree]{sim_ail_pedigree()}}
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}}
}
\keyword{datagen}
