% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_meiosis.R
\name{sim_meiosis}
\alias{sim_meiosis}
\title{Simulate meiosis}
\usage{
sim_meiosis(parent, m = 10, p = 0, obligate_chiasma = FALSE, Lstar = NULL)
}
\arguments{
\item{parent}{An individual object, as output by
\code{\link[=create_parent]{create_parent()}} or \code{\link[=cross]{cross()}}}

\item{m}{interference parameter for chi-square model}

\item{p}{Proportion of chiasmata coming from no-interference process.}

\item{obligate_chiasma}{If TRUE, require an obligate chiasma on the
4-strand bundle at meiosis.}

\item{Lstar}{Adjusted chromosome length, if
\code{obligate_chiasma=TRUE}. Calculated if not provided.}
}
\value{
A list with alleles in chromosome intervals (as integers)
and locations of the right endpoints of those intervals.
}
\description{
Output a random meiotic product from an input individual.
}
\details{
Simulations are under the Stahl model with the
interference parameter being an integer. This is an extension of
the chi-square model, but with chiasmata being the superposition of
two processes, one following the chi-square model and the other
exhibiting no interference.
}
\examples{
ind <- create_parent(100, 1:2)
prod <- sim_meiosis(ind)
}
\references{
Copenhaver, G. P., Housworth, E. A. and Stahl, F. W. (2002) Crossover
interference in arabidopsis.  \emph{Genetics} \bold{160}, 1631--1639.

Foss, E., Lande, R., Stahl, F. W. and Steinberg, C. M. (1993) Chiasma
interference as a function of genetic distance. \emph{Genetics}
\bold{133}, 681--691.

Zhao, H., Speed, T. P. and McPeek, M. S. (1995) Statistical analysis
of crossover interference using the chi-square model.  \emph{Genetics}
\bold{139}, 1045--1056.
}
\seealso{
\code{\link[=create_parent]{create_parent()}}, \code{\link[=cross]{cross()}},
\code{\link[=sim_crossovers]{sim_crossovers()}}, \code{\link[=calc_Lstar]{calc_Lstar()}}
}
\keyword{datagen}
