% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simgof.test.R
\name{simgof.test}
\alias{simgof.test}
\title{simgof.test}
\usage{
simgof.test(
  x,
  pnull,
  rnull,
  qnull = function(x) NULL,
  do.estimation = TRUE,
  estimate = function(x) NULL,
  include.methods = c(rep(TRUE, 7), rep(FALSE, 9)),
  B = 10000,
  lambda,
  nbins = NULL
)
}
\arguments{
\item{x}{data set}

\item{pnull}{distribution function under the null hypothesis}

\item{rnull}{routine to generate data under the null hypothesis}

\item{qnull}{quantile function under the null hypothesis}

\item{do.estimation}{TRUE if parameters are to be estimated}

\item{estimate}{routine for parameter estimation}

\item{include.methods}{which methods should be used, a vector of length 16 of T/F}

\item{B}{=10000  number of simulation runs}

\item{lambda}{rate of Poisson if sample size is random}

\item{nbins}{number of bins for chisquare test}
}
\value{
A numeric vector of p values
}
\description{
This function performs a number of gof tests and rejects the null if any of the tests does so. Then it finds the adjusted p-value.
}
\examples{
 x <- runif(1000)
 pnull <- function(x) x 
 rnull <- function(n) runif(n) 
 qnull <- function(x) x 
 simgof.test(x, pnull, rnull, qnull, FALSE, B=500)
 x <- rnorm(1000, 100, 20)
 pnull <- function(x, param) pnorm(x, param[1], param[2])
 rnull <- function(n, param) rnorm(x, param[1], param[2])
 qnull <- function(x, param) qnorm(x, param[1], param[2])
 estimate <- function(x) c(mean(x), sd(x))
 simgof.test(x, pnull, rnull, qnull, TRUE, estimate, B=500) 
}
