% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getData}
\alias{getData}
\alias{getData<-}
\title{Get an object's data.}
\usage{
getData(object)

getData(object) <- value
}
\arguments{
\item{object}{a fitted model object (e.g. an object of class \code{merMod} or \code{lm}).}

\item{value}{a new \code{data.frame} to replace the old one.
The new data will be stored in the \code{newData} attribute.}
}
\value{
A \code{data.frame} with the required data.
}
\description{
Get the data associated with a model object.
}
\details{
Looks for data in the following order:

\enumerate{
 \item{The object's \code{newData} attribute, if it has been set by \code{simr}.}
 \item{The \code{data} argument of \code{getCall(object)}, in the environment of \code{formula(object)}.}
}
}
\examples{

lm1 <- lmer(y ~ x + (1|g), data=simdata)
X <- getData(lm1)

}
