% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tandem.R
\name{tandem}
\alias{tandem}
\title{Initializes an instance of the tandem model required by the tandem methods.}
\usage{
tandem(
  seed = NULL,
  verbose = TRUE,
  init = "svd",
  n_max_iter = 10,
  n_loops = 10,
  tol = 1e-05,
  U_i_g = NULL,
  B_j_q = NULL,
  C_k_r = NULL
)
}
\arguments{
\item{seed}{Seed for random sequence generation.}

\item{verbose}{Flag to display iteration outputs for each loop.}

\item{init}{Parameter initialization method, 'svd' or 'random'.}

\item{n_max_iter}{Maximum number of iteration to optimize the objective function.}

\item{n_loops}{Maximum number of loops/runs for global results.}

\item{tol}{Allowable tolerance to check convergence.}

\item{U_i_g}{Initial membership function matrix for the objects.}

\item{B_j_q}{Initial component scores matrix for the variables.}

\item{C_k_r}{Initial component sores matrix for the occasions.}
}
\value{
An object of class "tandem".
}
\description{
Initializes an instance of the tandem model required by the tandem methods.
}
\references{
\insertRef{tandemModels}{simuclustfactor}
\insertRef{tucker1966}{simuclustfactor}
}
\seealso{
{
 \code{\link{fit.twcfta}} \code{\link{fit.twfcta}} \code{\link{simultaneous}}
}
}
