% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeOxyFile.R
\name{makeOxyFile}
\alias{makeOxyFile}
\title{Inserts roxygen2 skeletons in file(s).}
\usage{
makeOxyFile(input = NULL, overwrite = FALSE, verbose = interactive(), ...)
}
\arguments{
\item{input}{character, vector of path(s) to one or more .R files, a path to directory containing .R files, Default: NULL}

\item{overwrite}{logical, If TRUE overwrites file(s), FALSE writes "Oxy"- prefixed files in the same directory, Default: FALSE}

\item{verbose}{logical, If TRUE will print output to console and open edited files in the editor viewer, Default: interactive()}

\item{\dots}{additional parameters passed to \code{makeOxygen}}
}
\value{
Nothing. Writes files with roxygen2 comments as a side effect
}
\description{
Applies \code{makeOxygen} function to all functions/dataframes in supplied file(s)
}
\details{
If an object cannot be found it will be sourced into a temporary environment.
If the file already contains roxygen2 comments they will be deleted to avoid duplication.
Some functions may require attaching additional packages. For instance, if functions
were defined with purrr's \code{compose} or \code{partial} functions, omission of \code{purr::} in definitions will
require \code{library(purrr)} before proceeding with \code{makeOxyFile}.
}
\examples{
 
# copy dummy package to tempdir
  file.copy(system.file('pkg',package = 'sinew'),tempdir(),recursive = TRUE)
  pkg_dir <- file.path(tempdir(),'pkg')
  pkg_dir_R <- file.path(pkg_dir,'R')

# update namespaces in package functions
  pretty_namespace(pkg_dir_R, overwrite = TRUE)
   
 # test on one R file 
 # this will create a new R file called 'oxy-yy.R' in the same directory
   makeOxyFile(file.path(pkg_dir_R,'yy.R'))
 
 # Remove the file
   unlink(file.path(pkg_dir_R,'oxy-yy.R'))
 
 # Test on all R files in directory and overwrite the contents
   makeOxyFile(pkg_dir_R, overwrite = TRUE)
 
 # Remove Skeleton
   rmOxygen(file.path(pkg_dir_R,'yy.R'))
   rmOxygen(file.path(pkg_dir_R,'zz.R'))
   
 # adds more fields to defaults, passes "cut" to make_import
   sinew_opts$append(list(add_fields=c("concept", "describeIn")))
   makeOxyFile(file.path(pkg_dir_R,'yy.R'), cut = 5)
 
 # cleanup 
   unlink(pkg_dir, recursive = TRUE, force = TRUE)
   sinew_opts$restore()
   
}
\seealso{
\link[=makeOxygen]{makeOxygen}
}
\author{
Anton Grishin
}
\concept{populate}
