% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlandAltmanPlot.R
\name{BlandAltmanPlot}
\alias{BlandAltmanPlot}
\title{Bland-Altman plot function}
\usage{
BlandAltmanPlot(
  var1,
  var2,
  with_gradient = FALSE,
  line_color = c("blue", "lightblue"),
  extremum_pctg = TRUE
)
}
\arguments{
\item{var1}{a vector of numerics for the 1rst group to be compared.}

\item{var2}{a vector of numerics for the 2nd group to be compared.}

\item{with_gradient}{a logical indicating if you have a lot of measures, use \code{with_gradient=TRUE}
to have gradient scale and not points. Default value is FALSE.}

\item{line_color}{a vector of color for the three lines : average difference and
upper and lower limits of the confidence interval for the average difference.}

\item{extremum_pctg}{a logical indicating if you want to add the percentage of 
points outside the confidence interval for the upper and lower limits. Default is TRUE.}
}
\value{
a \code{ggplot2} object
}
\description{
Bland-Altman plot function
}
\examples{
 
library(ggplot2)

#Small sample
#Generate data
x <- rnorm(30)
y <- rnorm(30, mean = 5, sd = 3)
#Plotting
BlandAltmanPlot(var1 = x, var2 = y) 
#Add color by group 
gr  <- c(rep("G1", 15), rep("G2", 15))
BlandAltmanPlot(var1 = x, var2 = y) + geom_point(aes(color = gr))

#High sample
#Generate data
x <- rnorm(10000)
y <- rnorm(10000, mean = 5, sd = 3)
#Plotting with gradient
BlandAltmanPlot(var1 = x, var2 = y, with_gradient = TRUE)
}
