% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sitepickR-package.R
\docType{package}
\name{sitepickR-package}
\alias{sitepickR}
\alias{sitepickR-package}
\title{sitepickR: Two-Level Sample Selection with Optimal Site Replacement}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Carries out a two-level sample selection where the possibility of an initially selected site not wanting to participate is anticipated, and the site is optimally replaced. The procedure aims to reduce bias (and/or loss of external validity) with respect to the target population. In selecting units and sub-units, 'sitepickR' uses the cube method developed by 'Deville & Tillé', (2004) \url{http://www.math.helsinki.fi/msm/banocoss/Deville_Tille_2004.pdf} and described in Tillé (2011) \url{https://www150.statcan.gc.ca/n1/en/pub/12-001-x/2011002/article/11609-eng.pdf?st=5-sx8Q8n}. The cube method is a probability sampling method that is designed to satisfy criteria for balance between the sample and the population. Recent research has shown that this method performs well in simulations for studies of educational programs (see Fay & Olsen (2021, under review). To implement the cube method, 'sitepickR' uses the sampling R package \url{https://cran.r-project.org/package=sampling}. To implement statistical matching, 'sitepickR' uses the 'MatchIt' R package \url{https://cran.r-project.org/package=MatchIt}.
}
\author{
\strong{Maintainer}: Elena Badillo-Goicoechea \email{egoicoe1@jhu.edu}

Authors:
\itemize{
  \item Robert Olsen \email{robolsen@gwu.edu}
  \item Elizabeth Stuart \email{estuart1@jhu.edu}
}

}
\keyword{internal}
