% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{aws_user_exists}
\alias{aws_user_exists}
\title{Check if a user exists}
\usage{
aws_user_exists(username)
}
\arguments{
\item{username}{(character) the user name}
}
\value{
a single boolean
}
\description{
Check if a user exists
}
\details{
uses \code{\link[=aws_user]{aws_user()}} internally. see docs
\url{https://www.paws-r-sdk.com/docs/iam_get_user/}
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aws_user_exists(aws_user_current())
aws_user_exists("doesnotexist")
\dontshow{\}) # examplesIf}
}
\seealso{
Other users: 
\code{\link{aws_user}()},
\code{\link{aws_user_access_key}()},
\code{\link{aws_user_access_key_delete}()},
\code{\link{aws_user_add_to_group}()},
\code{\link{aws_user_create}()},
\code{\link{aws_user_current}()},
\code{\link{aws_user_delete}()},
\code{\link{aws_users}()},
\code{\link{six_user_create}()},
\code{\link{six_user_delete}()}
}
\concept{users}
