% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssp_chakraborti.R
\name{resample_n_locshift}
\alias{resample_n_locshift}
\title{Compute a distribution of estimates of N based on two pilot samples.}
\usage{
resample_n_locshift(
  s1,
  s2,
  delta,
  alpha = 0.05,
  power = 0.9,
  n_resamples = 500,
  q = 0.5
)
}
\arguments{
\item{s1, s2}{Pilot samples}

\item{delta}{numeric value, location shift parameter \eqn{\delta}}

\item{alpha}{Type I error probability}

\item{power}{1 - Type II error probability, the desired statistical
power}

\item{n_resamples}{number of resamples to use in bootstrapping}

\item{q}{size of group0 relative to total sample size.}
}
\value{
numeric vector of sample size estimates (total sample size)
}
\description{
Estimation of sample sizes based on resampled pilot samples from the empirical
cumulative density. Based on the work of Chakraborti, Hong, & van de Wiel (2006).
}
\details{
WARNING: Note that the estimation has high variability due to its dependence
on pilot samples. The smaller the pilot sample, the more uncertain is
the estimation of the required sample size. In a simulation study, we
found that the method may also be inaccurate on average, depending on
the investigated data.
}
\references{
Chakraborti, S., Hong, B., & van de Wiel, M. A. (2006). A note on
sample size determination for a nonparametric test of location.
Technometrics, 48(1), 88–94. https://doi.org/10.1198/004017005000000193
}
