% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_setup.r
\name{create_config_file}
\alias{create_config_file}
\title{Create the config file used in \code{slackr_setup()}}
\usage{
create_config_file(
  filename = "~/.slackr",
  token = Sys.getenv("SLACK_TOKEN"),
  incoming_webhook_url = Sys.getenv("SLACK_INCOMING_WEBHOOK_URL"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  username = Sys.getenv("SLACK_USERNAME"),
  channel = Sys.getenv("SLACK_CHANNEL")
)
}
\arguments{
\item{filename}{the name of the config file to save. We recommend using a hidden file (starting with '.')}

\item{token}{Authentication token bearing required scopes.}

\item{incoming_webhook_url}{the incoming webhook URL (Default: whatever is set as an env var).}

\item{icon_emoji}{the icon emoji to use as the default.}

\item{username}{the username to send messages from (will default to "slackr" if no username is set).}

\item{channel}{Channel, private group, or IM channel to send message to. Can be an encoded ID, or a name. See the \href{https://api.slack.com/methods/chat.postMessage#channels}{chat.postMessage endpoint documentation} for details.}
}
\value{
TRUE if successful (invisibly)
}
\description{
Create the config file used in \code{slackr_setup()}
}
\examples{
\dontrun{
# using `create_config_file()` after `slackr_setup()`
create_config_file()

# using `create_config_file()` before `slackr_setup()`
create_config_file(
  token = "xox-",
  incoming_webhook_url = "https://hooks-",
  channel = "#general",
  username = "slackr",
  icon_emoji = "tada"
)

slackr_setup()
}
}
\seealso{
\code{\link[=slackr_setup]{slackr_setup()}}
}
