% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slideView.R
\docType{methods}
\name{slideView}
\alias{slideView}
\alias{slideView,RasterStackBrick,RasterStackBrick-method}
\alias{slideView,SpatRaster,SpatRaster-method}
\alias{slideView,Raster,Raster-method}
\alias{slideView,Raster,RasterStackBrick-method}
\alias{slideView,RasterStackBrick,Raster-method}
\alias{slideView,character,character-method}
\alias{slideview,ANY-method}
\alias{slideview}
\title{slideView}
\usage{
\S4method{slideView}{SpatRaster,SpatRaster}(
  img1,
  img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())),
  r = 1,
  g = 2,
  b = 3,
  col.regions = viridisLite::inferno(256),
  legend = TRUE,
  na.color = "#BEBEBE",
  maxpixels = 1e+07,
  sliderInfoCSS = list(),
  ...
)

\S4method{slideView}{Raster,Raster}(
  img1,
  img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())),
  ...
)

\S4method{slideView}{RasterStackBrick,RasterStackBrick}(
  img1,
  img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())),
  ...
)

\S4method{slideView}{Raster,RasterStackBrick}(
  img1,
  img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())),
  ...
)

\S4method{slideView}{RasterStackBrick,Raster}(
  img1,
  img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())),
  ...
)

\S4method{slideView}{character,character}(
  img1,
  img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())),
  sliderInfoCSS = list()
)

\S4method{slideview}{ANY}(...)
}
\arguments{
\item{img1}{a RasterStack/Brick, RasterLayer or path to a .png file}

\item{img2}{a RasterStack/Brick, RasterLayer or path to a .png file}

\item{label1}{slider label for img1 (defaults to object name)}

\item{label2}{slider label for img2 (defaults to object name)}

\item{r}{integer. Index of the Red channel, between 1 and nlayers(x)}

\item{g}{integer. Index of the Green channel, between 1 and nlayers(x)}

\item{b}{integer. Index of the Blue channel, between 1 and nlayers(x)}

\item{col.regions}{color (palette).See \code{\link[lattice]{levelplot}} for details.}

\item{legend}{whether to plot legends for the two images (ignored for
RatserStacks/*Bricks).}

\item{na.color}{the color to be used for NA pixels}

\item{maxpixels}{integer > 0. Maximum number of cells to use for the plot.
If maxpixels < \code{ncell(x)}, sampleRegular is used before plotting.}

\item{sliderInfoCSS}{list of valid css key-value pairs for the slider info at
the top of the window.}

\item{...}{additional arguments passed on to respective functions.}

\item{color}{the color palette to be used for visualising RasterLayers}
}
\description{
Two images are overlaid and a slider is provided to interactively
compare the two images in a before-after like fashion. \code{img1} and
\code{img2} can either be two RasterLayers, two RasterBricks/Stacks or
two character strings. In the latter case it is assumed that these
point to .png images on the disk.

NOTE: In case you want to include multiple slideviews in one page in a
Rmd or flexdashboard we highly recommend using package widgetframe.
Also, make sure to use different image names and/or labels
for each of the RasterLayers/Bricks/Stacks.
Otherwise things will likely not work properly.

This is a modified implementation of http://bl.ocks.org/rfriberg/8327361
}
\details{
Compare two images trough interactive swiping overlay


For slideView a few keyboard shortcuts are defined:
\itemize{
  \item space - toggle antialiasing
  \item esc - zoom to layer extent
  \item enter - set zoom to 1
  \item ctrl - increase panning speed by 10
}
}
\section{Methods (by class)}{
\itemize{
\item \code{slideView(img1 = Raster, img2 = Raster)}: for RasterLayers

\item \code{slideView(img1 = RasterStackBrick, img2 = RasterStackBrick)}: for RasterStackBrick, RasterStackBrick

\item \code{slideView(img1 = Raster, img2 = RasterStackBrick)}: for RasterLayer, RasterStackBrick

\item \code{slideView(img1 = RasterStackBrick, img2 = Raster)}: for RasterStackBrick, RasterLayer

\item \code{slideView(img1 = character, img2 = character)}: for png files

\item \code{slideview(ANY)}: alias for ease of typing

}}
\examples{
if (interactive()) {
### example taken from
### http://www.news.com.au/technology/environment/nasa-images-reveal-
### aral-sea-is-shrinking-before-our-eyes/story-e6frflp0-1227074133835

library(jpeg)
library(terra)

web_img2000 <- "http://cdn.newsapi.com.au/image/v1/68565a36c0fccb1bc43c09d96e8fb029"

jpg2000 <- readJPEG(readBin(web_img2000, "raw", 1e6))

img2000 <- rast(jpg2000)

web_img2013 <- "http://cdn.newsapi.com.au/image/v1/5707499d769db4b8ec76e8df61933f2a"

jpg2013 <- readJPEG(readBin(web_img2013, "raw", 1e6))

img2013 <- rast(jpg2013)

slideView(img2000, img2013, label1 = "before", label2 = "after", legend = FALSE)

## adjust layout of the info slider
slideView(
  img2000
  , img2013
  , sliderInfoCSS = list(
    "background-color" = "#00ffff"
    , "color" = "#ff00ff"
    , opacity = 0.8
    , "font-size" = "30px"
    , "font-family" = "courier"
  )
  , legend = FALSE
)

}

}
\author{
Tim Appelhans

Stephan Woellauer
}
