% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_slim.R
\name{tune_slim}
\alias{tune_slim}
\title{tune_slim}
\usage{
tune_slim(mat, alphaRange = seq(0, 1, 0.1), nonNegCoeff = TRUE,
  nfold = 5L, seed, directory, nproc = 1L, progress = TRUE)
}
\arguments{
\item{mat}{(sparse matrix of class 'dgCMatrix') Rating matrix with items
along columns and users along rows.}

\item{alphaRange}{(numeric vector) A vector of alpha values with 0 <= alpha
<= 1. Default is values 0 to 1, with a difference of 0.1.}

\item{nonNegCoeff}{(flag) Whether the regression coefficients should be
non-negative. Default is TRUE.}

\item{nfold}{(positive integer) Number of folds for cross-validation. Only
values between(inclusive) 2 and 10 are allowed.}

\item{seed}{(positive integer) Seed to be used to create folds for
cross-validation. If missing, a random integer is chosen. Setting this is
helpful for reproduciing the results. Default is 5.}

\item{directory}{(string) A writable directory where a sub-directory is
created at the run time and \code{bigmatrix} objects will be written to.
The sub-directories are deleted at the end. If missing, this is set using
\code{tempdir()}}

\item{nproc}{(positive integer) Number of parallel processes to be used to
compute coefficients for items. If the machine has \code{k} (>1) cores, the
function does not employ more than \code{k - 1} cores. This is set to 1L by
default.}

\item{progress}{(flag) If TRUE(default), shows a progress bar and expected
time. This is set to TRUE by default.}
}
\value{
A dataframe with two columns: \code{alpha} and \code{error}.
}
\description{
Arrive at an optimal value of \code{alpha} for
  \code{\link{slim}}
}
\details{
Runs \code{nfold} cross-validation to aid determining the optimal
  value of \code{alpha}(see \code{\link{slim}} for details). The coefficient
  matrix obtained from the training fold is used to predict ratings of the
  validation fold. The RMSE is evaluated for non-zero ratings and averaged
  over all the folds. Note that coefficient matrix is held in memory while
  computing RMSE. \code{\link{slim}} adjusts \code{lambda} while fitting an
  elastic-net, hence advantages in searching for optimal \code{alpha} might
  be limited.
}
\examples{
require("slimrec")
data(ft_small)
\dontrun{
temp <- tune_slim(ft_small)
temp
temp <- tune_slim(ft_small, alphaRange = c(0, 0.5, 1))
temp
temp <- tune_slim(ft_small, alphaRange = c(0, 0.5, 1), nproc = 2)
temp
temp <- tune_slim(ft_small, nonNegCoeff = FALSE)
temp
}

}

