% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\name{cov_efromovich}
\alias{cov_efromovich}
\title{Spectral density estimation: Efromovich method}
\usage{
cov_efromovich(epsilon, plot = FALSE)
}
\arguments{
\item{epsilon}{numeric vector. An univariate process.}

\item{plot}{logical. By default, \code{plot = FALSE}. If \code{plot = TRUE}, the ACF of the process \code{epsilon}
is plotted.}
}
\value{
The function returns the estimated autocovariances of the process, that is the Fourier coefficients
 of the spectral density estimates, and the order chosen by the algorithm.
 \item{model_selec}{the number of selected autocovariance terms.}
 \item{cov_st}{the estimated autocovariances.}
}
\description{
This method estimates the spectral density and the autocovariances of the error process via a lag-window
 estimator based on the rectangular kernel (see P.J. Brockwell and R.A. Davis (1991). Time Series: Theory and Methods.
 \emph{Springer Science & Business Media}, page 330). The lag is computed according to Efromovich's algorithm (Efromovich (1998)).
}
\examples{
x = arima.sim(list(ar=c(0.4,0.2)),1000)
cov_efromovich(x)
}
\references{
P.J. Brockwell and R.A. Davis (1991). Time Series: Theory and Methods. \emph{Springer Science & Business Media}.

 E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.

 S. Efromovich (1998). Data-driven efficient estimation of the spectral density. \emph{Journal of the American Statistical Association}, 93(442), 762-769.
}
