\encoding{UTF-8}
\name{smoothHR-package}
\alias{smoothHR-package}
\docType{package}
\title{Smooth Hazard Ratio Curves Taking a Reference Value}
\description{
Provides flexible hazard ratio curves allowing non-linear relationships between continuous predictors and survival.
To better understand the effects that each continuous covariate has on the outcome, results are expressed in terms of hazard ratio curves,
taking a specific covariate value as reference. Confidence bands for these curves are also derived.
}

\details{
	\tabular{ll}{
		Package: \tab smoothHR\cr
		Type: \tab Package\cr
		Version: \tab 1.0.5\cr
		Date: \tab 2024-02-25\cr
		License: \tab GPL-3\cr
		LazyLoad: \tab yes\cr
		LazyData: \tab yes\cr
	}
}

\author{
Artur Araújo and Luís Meira-Machado \email{lmachado@math.uminho.pt}\cr
Maintainer: Artur Araújo \email{artur.stat@gmail.com}
}

\references{
Cadarso-Suarez, C. and Meira-Machado, L. and Kneib, T. and Gude, F. (2010). Flexible hazard ratio curves for continuous predictors in multi-state models: an application to breast cancer data. \emph{Statistical Modelling}, \bold{10}(3), 291-314. \doi{10.1177/1471082X0801000303}

Eilers, Paul H. and Marx, Brian D. (1996). Flexible smoothing with B-splines and penalties. \emph{Statistical Science}, \bold{11}(2), 89-121. \doi{10.1214/ss/1038425655}

Hosmer, D. W. and Lemeshow, S. and May, S. (2008). \emph{Applied Survival Analysis: Regression Modeling of Time to Event Data: Second Edition}, John Wiley and Sons Inc., New York, NY.

Hurvich, C. M. and Simonoff, J. S. and Tsai, Chih-Ling (1998). Smoothing parameter selection in nonparametric regression using an improved Akaike information criterion. \emph{JRSSB}, \bold{60}(2), 271-293. \doi{10.1111/1467-9868.00125}

Meira-Machado, L. and Cadarso-Suárez, C. and Gude, F. and Araújo, A. (2013). smoothHR: An R Package for Pointwise Nonparametric Estimation of Hazard Ratio Curves of Continuous Predictors. \emph{Computational and Mathematical Methods in Medicine}, \bold{2013}, 11 pages. \doi{10.1155/2013/745742}
}

\keyword{package}
