% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{objFunction}
\alias{objFunction}
\title{Auxiliary function to define the objective function of an L1 penalized regression operator.}
\usage{
objFunction(betavector, u, v, w)
}
\arguments{
\item{betavector}{The vector of regression coefficients.}

\item{u}{The function encoding the objective of the regression operator.}

\item{v}{The function encoding the penalty of the regression operator.}

\item{w}{The function encoding the dependence structure among the regression coefficients.}
}
\value{
The value of the L1 penalized regression operator for the input \eqn{betavector}.
}
\description{
Auxiliary function to define the objective function of an L1 penalized regression operator.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
lambda <- 1
temp <- standardLasso(X,y,lambda)
print(objFunction(betavector,temp$u,temp$v,temp$w))

}
\references{
Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
