% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{univariate}
\alias{univariate}
\title{Randomly generated univariate data}
\format{A data frame with 50 observations of two variables.
\describe{
  \item{x}{Input}
  \item{y}{Output}
}}
\usage{
univariate
}
\description{
A dataset for illustrating univariate non-parametric boundary
regressions and various constraints.
}
\details{
Generated with the following code:
\preformatted{
set.seed(100)

N <- 50
x <- runif(N, 10, 100)
y <- sapply(x, function(x) 500 * x^0.25 - dnorm(x, mean = 70, sd = 10) * 8000) - abs(rnorm(N, sd = 20))
y <- y - min(y) + 10
df <- data.frame(x, y)
}
}
\keyword{datasets}
