% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_analysis.r
\name{what.is.x}
\alias{what.is.x}
\title{Check if data is valid for soc.mca}
\usage{
what.is.x(x, check.na = TRUE)
}
\arguments{
\item{x}{the active variables sent to soc.mca}

\item{check.na}{If TRUE checks whether x contains NA values and returns an error}
}
\value{
a character vector with an evaluation of whether x is data.frame, a list of data.frames, an indicator or a list of indicators.
}
\description{
Performs tests on what has been passed on to soc.mca by the user.
}
\examples{
\dontrun{
  # Valid scenarios ----

# X is a valid data.frame
x <- taste[, 2:7]
what.is.x(x)  

# X is a valid indicator
x <- indicator(taste[, 2:7])
what.is.x(x)

# X is a valid list of data.frames with names
x <- list(nif = taste[, 2:3], hurma = taste[, 4:5])
what.is.x(x)  

# X is a valid list of indicators
x <- list(nif = indicator(taste[, 2:3]), hurma = indicator(taste[, 4:5]))
what.is.x(x)

# Invalid scenarios ----

# X is a data.frame - but does not contain only factors
x <- taste[, 2:7]
x[, 1] <- x[, 1] |> as.character()
what.is.x(x)  
# X is a matrix - but not numeric
x <- as.matrix(taste[, 2:7])
what.is.x(x)  

# X is a list of data.frames list but does not have names
x <- list(taste[, 1:3], taste[, 4:5])
what.is.x(x)

# X is a list of indicators but does not have names
x <- list(indicator(taste[, 2:3]), indicator(taste[, 4:5]))
what.is.x(x)

# X is a data.frame and contains NA
x <- taste[, 2:7]
x[1,1] <- NA
what.is.x(x)

# X is a list of indicators and contains NA
x <- list(nif = indicator(taste[, 2:3]), hurma = indicator(taste[, 4:5]))
x[[1]][1,1] <- NA
what.is.x(x)

# X contains elements that are neither a matrix nor a data.frame
x <- list(nif = 1:10, taste[, 1:3], taste[, 4:7])
what.is.x(x)

# X contains both indicators and matrixes
x <- list(nif = taste[, 2:3], hurma = indicator(taste[, 5:6]))
what.is.x(x)
}
}
