% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipes.R
\name{testRelation}
\alias{testRelation}
\alias{\%:\%}
\alias{\%>=dom\%}
\alias{\%>dom\%}
\alias{\%>=cumuldom\%}
\alias{\%>cumuldom\%}
\alias{\%>=cp\%}
\alias{\%>cp\%}
\alias{\%>=banz\%}
\alias{\%>banz\%}
\alias{\%>=cop\%}
\alias{\%>cop\%}
\alias{\%>=ks\%}
\alias{\%>ks\%}
\alias{\%>=lex\%}
\alias{\%>lex\%}
\alias{\%>=duallex\%}
\alias{\%>duallex\%}
\alias{\%>=L1\%}
\alias{\%>L1\%}
\alias{\%>=L2\%}
\alias{\%>L2\%}
\alias{\%>=LP\%}
\alias{\%>LP\%}
\alias{\%>=LPS\%}
\alias{\%>LPS\%}
\title{Test relation between two elements}
\usage{
testRelation(powerRelation, e1)

powerRelation \%:\% e1

pr_e1 \%>=dom\% e2

pr_e1 \%>dom\% e2

pr_e1 \%>=cumuldom\% e2

pr_e1 \%>cumuldom\% e2

pr_e1 \%>=cp\% e2

pr_e1 \%>cp\% e2

pr_e1 \%>=banz\% e2

pr_e1 \%>banz\% e2

pr_e1 \%>=cop\% e2

pr_e1 \%>cop\% e2

pr_e1 \%>=ks\% e2

pr_e1 \%>ks\% e2

pr_e1 \%>=lex\% e2

pr_e1 \%>lex\% e2

pr_e1 \%>=duallex\% e2

pr_e1 \%>duallex\% e2

pr_e1 \%>=L1\% e2

pr_e1 \%>L1\% e2

pr_e1 \%>=L2\% e2

pr_e1 \%>L2\% e2

pr_e1 \%>=LP\% e2

pr_e1 \%>LP\% e2

pr_e1 \%>=LPS\% e2

pr_e1 \%>LPS\% e2
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{e1, e2}{Elements in \code{powerRelation$elements}}

\item{pr_e1}{\code{\link{PowerRelation}} and \code{e1} element, packed into a list using \code{pr \%:\% e1}}
}
\value{
\code{testRelation()} and \verb{\%:\%} returns \code{list(powerRelation, e1)}.

Followed by a \verb{\%>=comparison\%} or \verb{\%>comparison\%} it returns \code{TRUE} or \code{FALSE}, depending on the relation between
\code{e1} and \code{e2}.
}
\description{
On a given \code{\link{PowerRelation}} object \code{pr}, check if \code{e1} relates to \code{e2} based on the given social ranking solution.
}
\details{
The function \code{testRelation} is somewhat only used to make the offered comparison operators in the package better discoverable.

\code{testRelation(pr, e1)} is equivalent to \code{pr \%:\% e1} and \code{list(pr, e1)}. It should be used together with one of the
comparison operators listed in the usage section.
}
\examples{
pr <- as.PowerRelation("123 > 12 ~ 13 ~ 23 > 3 > 1 ~ 2 > {}")

# Dominance
stopifnot(pr \%:\% 1 \%>=dom\% 2)

# Strict dominance
stopifnot((pr \%:\% 1 \%>dom\% 2) == FALSE)

# Cumulative dominance
stopifnot(pr \%:\% 1 \%>=cumuldom\% 2)

# Strict cumulative dominance
stopifnot((pr \%:\% 1 \%>cumuldom\% 2) == FALSE)

# CP-Majority relation
stopifnot(pr \%:\% 1 \%>=cp\% 2)

# Strict CP-Majority relation
stopifnot((pr \%:\% 1 \%>cp\% 2) == FALSE)

# Ordinal banzhaf relation
stopifnot(pr \%:\% 1 \%>=banz\% 2)

# Strict ordinal banzhaf relation
# (meaning 1 had a strictly higher positive contribution than 2)
stopifnot((pr \%:\% 1 \%>banz\% 2) == FALSE)

# Copeland-like method
stopifnot(pr \%:\% 1 \%>=cop\% 2)
stopifnot(pr \%:\% 2 \%>=cop\% 1)

# Strict Copeland-like method
# (meaning pairwise winning minus pairwise losing comparison of
# 1 is strictly higher than of 2)
stopifnot((pr \%:\% 1 \%>cop\% 2) == FALSE)
stopifnot((pr \%:\% 2 \%>cop\% 1) == FALSE)
stopifnot(pr \%:\% 3 \%>cop\% 1)

# Kramer-Simpson-like method
stopifnot(pr \%:\% 1 \%>=ks\% 2)
stopifnot(pr \%:\% 2 \%>=ks\% 1)

# Strict Kramer-Simpson-like method
# (meaning ks-score of 1 is actually higher than 2)
stopifnot((pr \%:\% 2 \%>ks\% 1) == FALSE)
stopifnot((pr \%:\% 1 \%>ks\% 2) == FALSE)
stopifnot(pr \%:\% 3 \%>ks\% 1)

# Lexicographical and dual lexicographical excellence
stopifnot(pr \%:\% 3 \%>=lex\% 1)
stopifnot(pr \%:\% 3 \%>=duallex\% 1)

# Strict lexicographical and dual lexicographical excellence
# (meaning their lexicographical scores don't match)
stopifnot(pr \%:\% 3 \%>lex\% 1)
stopifnot(pr \%:\% 3 \%>duallex\% 1)

# L^(1) and L^(2)
stopifnot(pr \%:\% 1 \%>=L1\% 2)
stopifnot(pr \%:\% 1 \%>=L2\% 2)

# Strict L^(1) and L^(2)
stopifnot((pr \%:\% 1 \%>L1\% 2) == FALSE)
stopifnot(pr \%:\% 3 \%>L1\% 1)

stopifnot((pr \%:\% 1 \%>L2\% 2) == FALSE)
stopifnot(pr \%:\% 3 \%>L2\% 1)

# L^p and L^p*
stopifnot(pr \%:\% 1 \%>=LP\% 2)
stopifnot(pr \%:\% 1 \%>=LPS\% 2)

# Strict L^(1) and L^(2)
stopifnot((pr \%:\% 1 \%>LP\% 2) == FALSE)
stopifnot(pr \%:\% 3 \%>LP\% 1)

stopifnot((pr \%:\% 1 \%>LPS\% 2) == FALSE)
stopifnot(pr \%:\% 3 \%>LPS\% 1)

}
\seealso{
Comparison function: \code{\link[=dominates]{dominates()}}, \code{\link[=cumulativelyDominates]{cumulativelyDominates()}}, \code{\link[=cpMajorityComparison]{cpMajorityComparison()}}.

Score Functions: \code{\link[=ordinalBanzhafScores]{ordinalBanzhafScores()}}, \code{\link[=copelandScores]{copelandScores()}}, \code{\link[=kramerSimpsonScores]{kramerSimpsonScores()}}, \code{\link[=lexcelScores]{lexcelScores()}}.
}
