% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_irf.R
\name{lp_irf}
\alias{lp_irf}
\title{Estimate impulse response functions}
\usage{
lp_irf(lp, CI = c(0.1, 0.9), regime = NULL)
}
\arguments{
\item{lp}{LP output}

\item{CI}{numeric vector: c(lower ci bound, upper ci bound)}

\item{regime}{string: indicates regime index column of data}
}
\value{
long-form data.frame with one row per target-shock-horizon identifier
}
\description{
Estimate impulse response functions
}
\examples{
\donttest{

  # simple time series
  AA = c(1:100) + rnorm(100)
  BB = c(1:100) + rnorm(100)
  CC = AA + BB + rnorm(100)
  date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
  Data = data.frame(date = date, AA, BB, CC)

  # local projection forecasts
  lp =
    sovereign::LP(
      data = Data,
      horizon = c(1:10),
      lag.ic = 'AIC',
      lag.max = 4,
      type =  'both',
      freq = 'month')

  # impulse response function
  irf = sovereign::lp_irf(lp)

}

}
\seealso{
\code{\link[=LP]{LP()}}

\code{\link[=lp_irf]{lp_irf()}}

\code{\link[=RLP]{RLP()}}

\code{\link[=rlp_irf]{rlp_irf()}}
}
