% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{conv_opt}
\alias{conv_opt}
\title{Solver for Bayesian Predictive Stacking of Predictive densities convex optimization problem}
\usage{
conv_opt(scores)
}
\arguments{
\item{scores}{\link{matrix} \eqn{N \times K} of expected predictive density evaluations for the K models considered}
}
\value{
W \link{matrix} of Bayesian Predictive Stacking weights for the K models considered
}
\description{
Solver for Bayesian Predictive Stacking of Predictive densities convex optimization problem
}
\examples{
## Generate (randomly) K predictive scores for n observations
n <- 50
K <- 5
scores <- matrix(runif(n*K), nrow = n, ncol = K)

## Find Bayesian Predictive Stacking weights
opt_weights <- conv_opt(scores)

}
