% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinar_penal_val.R
\name{spinar_penal_val}
\alias{spinar_penal_val}
\title{Validated penalized semiparametric estimation of INAR models}
\usage{
spinar_penal_val(
  x,
  p,
  validation,
  penal1 = NA,
  penal2 = NA,
  over = NA,
  folds = 10,
  init1 = 1,
  init2 = 1,
  progress = TRUE
)
}
\arguments{
\item{x}{[\code{integer}]\cr
vector with integer observations.}

\item{p}{[\code{integer(1)}]\cr
order of the INAR model, where \eqn{\code{p} \in \{1,2\}}.}

\item{validation}{[\code{logical(1)}]\cr
indicates whether validation is wanted.}

\item{penal1}{[\code{numeric(1)}]\cr
\eqn{L_1} penalization parameter.
It will be ignored if \code{validation = TRUE} and \code{over} \eqn{\in \{"both", "L_1"\}}. It is mandatory if \code{validation = FALSE}.}

\item{penal2}{[\code{numeric(1)}]\cr
\eqn{L_2} penalization parameter.
It will be ignored if \code{validation = TRUE} and \code{over} \eqn{\in \{"both", "L_2"\}}. It is mandatory if \code{validation = FALSE}.}

\item{over}{[\code{string(1)}]\cr
validation over \code{"both"} penalization parameters or only over \code{"L_1"} or \code{"L_2"}.
It is mandatory if \code{validation = TRUE}, otherwise it will be ignored.}

\item{folds}{[\code{integer(1)}]\cr
number of folds for (cross) validation.}

\item{init1}{[\code{numeric(1)}]\cr
initial value for penal1 in validation. Default value is init1 = 1.}

\item{init2}{[\code{numeric(1)}]\cr
initial value for penal2 in validation. Default value is init2 = 1}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default is \code{TRUE}.}
}
\value{
If \code{validation = FALSE}, the function returns a vector containing the penalized estimated coefficients
\eqn{\code{alpha}_1,...,\code{alpha}_p} and the penalized estimated entries of the pmf \eqn{\code{pmf}_0, \code{pmf}_1}... where \eqn{\code{pmf}_i} represents the probability of
an innovation being equal to \eqn{i}.

If \code{validation = TRUE}, the function returns a named list, where the first entry contains
the penalized estimated coefficients \eqn{\code{alpha}_1,...,\code{alpha}_p} and the penalized estimated entries of the pmf \eqn{\code{pmf}_0, \code{pmf}_1},... where \eqn{\code{pmf}_i} represents the probability of
an innovation being equal to \eqn{i}. The second (and if \code{over = both} also the third entry) contain(s) the validated penalization parameter(s).
}
\description{
Semiparametric penalized estimation of the autoregressive parameters and the innovation distribution of INAR(\code{p}) models,
\eqn{\code{p} \in \{1,2\}}. The estimation is conducted by maximizing the penalized conditional likelihood of the model.
Included is a possible validation of one or both penalization parameters. If no validation is wanted, the function coincides
to the spinar_penal function of this package.
}
\examples{
# generate data
dat1 <- spinar_sim(n = 50, p = 1, alpha = 0.5,
                   pmf = c(0.3, 0.3, 0.2, 0.1, 0.1))

\donttest{
# penalized semiparametric estimation with validation over L1
spinar_penal_val(x = dat1, p = 1, validation = TRUE, penal2 = 0.1,
                 over = "L1")
# penalized semiparametric estimation with validation over both L1 and L2
spinar_penal_val(x = dat1, p = 1, validation = TRUE, over = "both")}

}
