% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparegcv.R
\name{coef.spar.cv}
\alias{coef.spar.cv}
\title{Coef Method for \code{'spar.cv'} Object}
\usage{
\method{coef}{spar.cv}(
  object,
  nummod = NULL,
  nu = NULL,
  opt_par = c("best", "1se"),
  aggregate = c("mean", "median", "none"),
  ...
)
}
\arguments{
\item{object}{result of \link{spar.cv} function of class \code{'spar.cv'}.}

\item{nummod}{optional number of models used to form coefficients}

\item{nu}{optional threshold level used to form coefficients}

\item{opt_par}{one of \code{c("1se","best")}, chooses whether to select the
best pair of \code{nus} and \code{nummods} according to cross-validated
(CV) measure, or the sparsest solution within one sd of that optimal
CV measure;
ignored when \code{nummod} and \code{nu} are given}

\item{aggregate}{character one of c("mean", "median", "none"). If set to "none"
the coefficients are not aggregated over the marginal models, otherwise
the coefficients are aggregated using the specified method (mean or median).
Defaults to mean aggregation.}

\item{...}{further arguments passed to or from other methods}
}
\value{
List with elements
\itemize{
\item \code{intercept} intercept value
\item \code{beta} vector of length p of averaged coefficients
\item \code{nummod} number of models based on which the coefficient is computed
\item \code{nu}  threshold based on which the coefficient is computed
}
}
\description{
Extract coefficients from \code{'spar.cv'} object
}
\examples{
\donttest{
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_res <- spar.cv(example_data$x, example_data$y, nfolds = 3L,
  nummods = c(5, 10))
coef(spar_res)
}
}
