% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{bigquery_defaults}
\alias{bigquery_defaults}
\title{Google BigQuery Default Settings}
\usage{
bigquery_defaults(billingProjectId, gcsBucket, datasetLocation = "US",
  serviceAccountKeyFile = NULL, type = "direct")
}
\arguments{
\item{billingProjectId}{Default Google Cloud Platform project ID for billing purposes.
This is the project on whose behalf to perform BigQuery operations.}

\item{gcsBucket}{Google Cloud Storage (GCS) bucket to use for storing temporary files.
Temporary files are used when importing through BigQuery load jobs and exporting through
BigQuery extraction jobs (i.e. when using data extracts such as Parquet, Avro, ORC, ...).
The service account specified in \code{serviceAccountKeyFile} needs to be given appropriate
rights. This should be the name of an existing storage bucket.}

\item{datasetLocation}{Geographic location where newly created datasets should reside.
"EU" or "US". Defaults to "US".}

\item{serviceAccountKeyFile}{Google Cloud service account key file to use for authentication
with Google Cloud services. The use of service accounts is highly recommended. Specifically,
the service account will be used to interact with BigQuery and Google Cloud Storage (GCS).
If not specified, Google application default credentials (ADC) will be used, which is the default.}

\item{type}{Default BigQuery import/export type to use. Options include "direct",
"parquet", "avro", "orc", "json" and "csv". Defaults to "direct".
Please note that only "direct" and "avro" are supported for both importing and exporting. \cr
"csv" and "json" are not recommended due to their lack of type safety.

See the table below for supported type and import/export combinations.

\tabular{lcccccc}{
                                         \tab Direct \tab Parquet \tab Avro \tab ORC \tab JSON \tab CSV  \cr
  Import to Spark (export from BigQuery) \tab X      \tab         \tab X    \tab     \tab X    \tab X    \cr
  Export from Spark (import to BigQuery) \tab X      \tab X       \tab X    \tab X   \tab      \tab      \cr
}}
}
\value{
A \code{list} of set options with previous values.
}
\description{
Sets default values for several Google BigQuery related settings.
}
\references{
\url{https://github.com/miraisolutions/spark-bigquery}
\url{https://cloud.google.com/bigquery/pricing}
\url{https://cloud.google.com/bigquery/docs/dataset-locations}
\url{https://cloud.google.com/bigquery/docs/authentication/service-account-file}
\url{https://cloud.google.com/docs/authentication/}
\url{https://cloud.google.com/bigquery/docs/authentication/}
\url{https://cloud.google.com/bigquery/docs/loading-data-cloud-storage-parquet}
\url{https://cloud.google.com/bigquery/docs/loading-data-cloud-storage-avro}
\url{https://cloud.google.com/bigquery/docs/loading-data-cloud-storage-orc}
\url{https://cloud.google.com/bigquery/docs/loading-data-cloud-storage-json}
\url{https://cloud.google.com/bigquery/docs/loading-data-cloud-storage-csv}
}
\seealso{
\code{\link{spark_read_bigquery}}, \code{\link{spark_write_bigquery}},
\code{\link{default_billing_project_id}}, \code{\link{default_gcs_bucket}},
\code{\link{default_dataset_location}}
}
\keyword{connection}
\keyword{database}
