% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_utils.R
\name{to_sdf}
\alias{to_sdf}
\alias{toSDF}
\title{Export data from TimeSeriesRDD to a Spark dataframe}
\usage{
to_sdf(ts_rdd)

toSDF(ts_rdd)
}
\arguments{
\item{ts_rdd}{A TimeSeriesRDD object}
}
\value{
A Spark dataframe containing time series data exported from `ts_rdd`
}
\description{
Construct a Spark dataframe containing time series data from a TimeSeriesRDD
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), v = seq(10)))
  ts <- from_sdf(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  ts_avg <- summarize_avg(ts, column = "v", window = in_past("3s"))
  # now export the average values from `ts_avg` back to a Spark dataframe
  # named `sdf_avg`
  sdf_avg <- ts_avg \%>\% to_sdf()
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other Spark dataframe utility functions: 
\code{\link{collect.ts_rdd}()},
\code{\link{from_rdd}()},
\code{\link{from_sdf}()},
\code{\link{spark_connection.ts_rdd}()},
\code{\link{spark_dataframe.ts_rdd}()},
\code{\link{spark_jobj.ts_rdd}()},
\code{\link{ts_rdd_builder}()}

Other Spark dataframe utility functions: 
\code{\link{collect.ts_rdd}()},
\code{\link{from_rdd}()},
\code{\link{from_sdf}()},
\code{\link{spark_connection.ts_rdd}()},
\code{\link{spark_dataframe.ts_rdd}()},
\code{\link{spark_jobj.ts_rdd}()},
\code{\link{ts_rdd_builder}()}
}
\concept{Spark dataframe utility functions}
