% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{svds.sparseLRMatrix}
\alias{svds.sparseLRMatrix}
\title{Truncated singular value decomposition of a matrix}
\usage{
\method{svds}{sparseLRMatrix}(A, k, nu = k, nv = k, opts = list(), ...)
}
\arguments{
\item{A}{Matrix to decompose.}

\item{k}{Number of singular values to estimate.}

\item{nu}{Number of left singular vectors to estimate.}

\item{nv}{Number of right singular vectors to estimate.}

\item{opts}{Passed to \code{\link[RSpectra:svds]{RSpectra::svds()}}.}

\item{...}{Passed to \code{\link[RSpectra:svds]{RSpectra::svds()}}.}
}
\value{
A list with the following components:
\item{d}{A vector of the computed singular values.}
\item{u}{An \code{m} by \code{nu} matrix whose columns contain
         the left singular vectors. If \code{nu == 0}, \code{NULL}
         will be returned.}
\item{v}{An \code{n} by \code{nv} matrix whose columns contain
         the right singular vectors. If \code{nv == 0}, \code{NULL}
         will be returned.}
\item{nconv}{Number of converged singular values.}
\item{niter}{Number of iterations used.}
\item{nops}{Number of matrix-vector multiplications used.}
}
\description{
A thin wrapper around \code{\link[RSpectra:svds]{RSpectra::svds()}}, please see more detailed
documentation there. In particular, this function leverages the
function interface.
}
\examples{

set.seed(528491)

n <- 50
m <- 40
k <- 3

A <- rsparsematrix(n, m, 0.1)

U <- Matrix(rnorm(n * k), nrow = n, ncol = k)
V <- Matrix(rnorm(m * k), nrow = m, ncol = k)

X <- sparseLRMatrix(sparse = A, U = U, V = V)

svds(X, 5)

}
