% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SENB.R
\name{SENB}
\alias{SENB}
\title{Fit Self-Exciting Negative Binomial Model with Prediction}
\usage{
SENB(
  cases,
  pop = NULL,
  casesoldold = 0,
  covariates = NULL,
  covariatespred = NULL,
  poppred = NULL,
  casesoldpred = 0,
  casespred = NULL,
  beta_init = NULL,
  r_init = NULL,
  beta_prior_mean = 0,
  beta_prior_sd = 10,
  r_prior_shape = 1,
  r_prior_rate = 1,
  n_iter = 1e+05,
  n_burnin = 10000,
  n_chains = 3,
  n_thin = 1,
  save_params = c("beta", "r", "eta")
)
}
\arguments{
\item{cases}{Vector of observed counts (length N)}

\item{pop}{Optional vector of population offsets (length N)}

\item{casesoldold}{Optional parameter of the cases of 1 timepoint previous than the start of timepoints fit.}

\item{covariates}{Optional numeric matrix (N x P) of covariates for the count component.}

\item{covariatespred}{Optional numeric matrix (M x P) of new covariates for count prediction.}

\item{poppred}{Optional vector of population offsets (length M) for prediction.}

\item{casesoldpred}{Optional parameter of the cases of 1 timepoint previous than the start of the prediction.}

\item{casespred}{Optional vector of true counts (length M) for prediction performance.}

\item{beta_init}{Optional list of length n_chains for beta, count coefficients initial values.}

\item{r_init}{Optional numeric vector of length n_chains for dispersion parameter.}

\item{beta_prior_mean}{Mean for beta prior (default: 0)}

\item{beta_prior_sd}{SD   for beta prior (default: 10)}

\item{r_prior_shape}{Shape for r ~ dgamma (default: 1)}

\item{r_prior_rate}{Rate  for r ~ dgamma (default: 1)}

\item{n_iter}{Total MCMC iterations (default: 100000)}

\item{n_burnin}{Burn-in iterations (default: 10000)}

\item{n_chains}{Number of chains (default: 3)}

\item{n_thin}{Thinning interval (default: 1)}

\item{save_params}{Character vector of parameters to save (default c("beta","r","eta"))}
}
\value{
A list with MCMC summary, samples, DIC, and if prediction data provided:
prediction_matrix, prediction_mean, mae, rmse
}
\description{
Fits a self-exciting negative binomial (SE-NB) model using JAGS, with an optional
design matrix of covariates and full inprod for mean structure, and
can generate posterior predictive counts including self-excitation.
}
\examples{
# ---- tiny example for users & CRAN (< 5s) ----
set.seed(1)
cases <- rnbinom(72, size = 5, mu = 8)  # toy NB series

\dontshow{
# checks that run on CRAN but are hidden from users
stopifnot(length(cases) == 72, all(cases >= 0))
}

# ---- actually fit the model, but only when JAGS is available ----
\dontshow{if (nzchar(Sys.which("jags")) && requireNamespace("R2jags", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
fit <- SENB(
  cases = cases,
  beta_prior_mean = 0,
  beta_prior_sd   = 5,
  r_prior_shape   = 2,
  r_prior_rate    = 0.5,
  n_iter   = 400,  # keep fast
  n_burnin = 200,
  n_chains = 1,
  n_thin   = 2
)
print(fit)

\donttest{
# ---- longer user-facing demo (skipped on checks) ----
if (nzchar(Sys.which("jags")) && requireNamespace("R2jags", quietly = TRUE)) {
  fit2 <- SENB(
    cases = cases,
    beta_prior_mean = 0,
    beta_prior_sd   = 5,
    r_prior_shape   = 2,
    r_prior_rate    = 0.5,
    n_iter   = 1500,
    n_burnin = 500,
    n_chains = 2,
    n_thin   = 2
  )
  print(fit2)
}
}

\dontrun{
# ---- time-consuming / full demo ----
if (nzchar(Sys.which("jags")) && requireNamespace("R2jags", quietly = TRUE)) {
  fit_full <- SENB(
    cases = cases,
    beta_prior_mean = 0,
    beta_prior_sd   = 5,
    r_prior_shape   = 2,
    r_prior_rate    = 0.5,
    n_iter   = 10000,
    n_burnin = 5000,
    n_chains = 4,
    n_thin   = 5
  )
  print(fit_full)
}
}

if (interactive()) {
  # e.g., plot(fit)
}
\dontshow{\}) # examplesIf}
}
