% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n.1subgroup.r
\name{n.1subgroup}
\alias{n.1subgroup}
\title{Sample Size Calculation for a One Subgroup Design}
\source{
\code{n.1subgroup} uses code contributed by Marius Placzek.
}
\usage{
n.1subgroup(
  alpha,
  beta,
  delta,
  sigma,
  tau,
  eps = 0.001,
  approx = c("conservative.t", "liberal.t", "normal"),
  k = 1,
  nmax = 1000,
  nmin = 0
)
}
\arguments{
\item{alpha}{level (type I error) to which the hypothesis is tested.}

\item{beta}{type II error (power=1-beta) to which an alternative should be proven.}

\item{delta}{vector of treatment effects to be proven, c(outside subgroup, inside subgroup).}

\item{sigma}{vector of standard deviations, c(outside subgroup, inside subgroup).}

\item{tau}{subgroup prevalence.}

\item{eps}{precision parameter concerning the power calculation in the iterative sample size search algorithm.}

\item{approx}{approximation method: Use a conservative multivariate t distribution ("conservative.t"), a liberal multivariate t distribution ("liberal.t") or a multivariate normal distribution ("normal") to approximate the joint distribution of the standardized teststatistics.}

\item{k}{sample size allocation factor between groups: see 'Details'.}

\item{nmax}{maximum total sample size.}

\item{nmin}{minimum total sample size.}
}
\value{
\code{n.1subgroup} returns the required sample size within the control group and treatment group.
}
\description{
\code{n.1subgroup} calculates the required sample size for proving a desired alternative when testing for
an effect in the full or subpopulation. See 'Details' for more information.
}
\details{
This function performs sample size estimation in a design with a subgroup within a full population where we want to test for treatment effects between a control and a treatment group. Since patients from the subgroup might potentially benefit from the treatment more than patients not included in that subgroup, one might prefer testing hypothesis cercerning the full population and the subpopulation at the same time. Here standardized test statistics are their joined distributions are used to calculate the
required sample size for the control and treatment group to prove an existing
alternative \code{delta} with a specified power 1-\code{beta} when testing the global null hypothesis \eqn{H_0: \Delta_F=\Delta_S=0} to level \code{alpha}.

For sample sizes \eqn{n_C} and \eqn{n_T} of the control and treatment group, respectively, the argument \code{k} is the
sample size allocation factor, i.e. \eqn{k = n_T/n_C}.
}
\examples{
#Calculate required sample size to correctly reject with
#80\% probability when testing the global Nullhypothesis H_0: Delta_F=Delta_S = 0
#assuming the true effect Delta_S=1 is in the subgroup (no effect outside of the subgroup)
#with subgroup prevalence tau=0.4.
#The variances in and outside of the subgroup are unequal, sigma=c(1,1.2).

estimate<-n.1subgroup(alpha=0.025,beta=0.1,delta=c(0,1),sigma=c(1,1.2),tau=0.4,eps=0.0001,
approx="conservative.t",k=2)
summary(estimate)
}
\seealso{
#' \code{\link{bssr.1subgroup}} for blinded sample size reestimation within a running trial.
}
