% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spatgeom.R
\name{plot_alpha_shape}
\alias{plot_alpha_shape}
\title{Plot alpha-shape for \code{spatgeom} objects}
\usage{
plot_alpha_shape(x, alpha, font_size = 12)
}
\arguments{
\item{x}{an object of class \code{spatgeom}.}

\item{alpha}{value of \code{alpha} determining the maximum length between
points to build the alpha-shape.}

\item{font_size}{a integer that increases the font size in the plot.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object with the raw alpha-shape for
the original data at resolution \code{alpha}
}
\description{
Plot alpha-shape for \code{spatgeom} objects.
}
\examples{
xy <- donut_data(n = 30, a = -1, b = 1, theta = 2 * pi)

estimation <- spatgeom(y = xy[, 1], x = xy[, -1])

plot_alpha_shape(estimation, alpha = c(0.9, 1.2))
}
