% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points_to_polygon.R
\name{points_to_polygon}
\alias{points_to_polygon}
\title{Map points to polygons}
\usage{
points_to_polygon(sf_map, df, oper, crs = 4326, outside_print = FALSE)
}
\arguments{
\item{sf_map}{object of class sf representing the polygon geometries.}

\item{df}{data.frame containing coordinates (column names should be 'lon'
and 'lat')}

\item{oper}{arithmetic operation to be applied on the polygon level.}

\item{crs}{coordinate reference system (default is 4326).}

\item{outside_print}{logical indicating whether to print points that are
not within a polygon (default is FALSE).}
}
\value{
An object of class \code{sf}
}
\description{
Join a data.frame containing coordinates (longitude and
latitude) to polygon geometries. Arithmetic operations are then applied to
the attributes of the joined coordinates to obtain aggregated values
for each polygon.
}
\examples{
points_to_polygon(nl_postcode2, insurance, sum(amount, na.rm = TRUE))
\dontrun{
shp_read <- sf::st_read("~/path/to/file.shp")
points_to_polygon(shp_read, insurance, sum(amount, na.rm = TRUE))
}

}
\author{
Martin Haringa
}
