% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_range.R
\name{compute_effective_range}
\alias{compute_effective_range}
\alias{compute_effective_range_nochecks}
\title{Compute effective range}
\usage{
compute_effective_range(
  X,
  coords = X[, c("x", "y")],
  df = 3,
  nsamp = min(1000, nrow(X)),
  smoothedCurve = FALSE,
  newd = seq(0, 1, 100),
  scale_factor = 1,
  returnFull = FALSE,
  cl = NULL,
  namestem = "tprs",
  inds = NULL,
  verbose = FALSE,
  span = 0.1
)

compute_effective_range_nochecks(
  X,
  inds,
  newd,
  D,
  smoothedCurve = FALSE,
  scale_factor = 1,
  returnFull = FALSE,
  cl = NULL,
  span = 0.1
)
}
\arguments{
\item{X}{Matrix of spline values. See \code{namestem} for expected column names.}

\item{coords}{Matrix of point coordinates. Defaults to the \code{x} and \code{y} columns of \code{X}, but can have a different number of columns for settings with different dimensions.}

\item{df}{Degrees of freedom for which effective range should be computed.}

\item{nsamp}{Number of observations from \code{X} from which to sample. Defaults to minimum of 1,000 and \code{nrow(X)}.}

\item{smoothedCurve}{Should the effective range be computed using the procedure introduced by Keller and Szpiro, 2020, (\code{TRUE}) or the procedure introduced by Rainey and Keller, 2024, (\code{FALSE}). See Details.}

\item{newd}{Distance values at which to make loess predictions. Should correspond to distances in the same units as \code{coords}. Only needed when \code{smoothedCurve} is \code{TRUE}.}

\item{scale_factor}{Factor by which range should be scaled. Often physical distance corresponding to resolution of grid. Defaults to 1, so that range is reported on the same scale as distance in \code{coords}. Only needed when \code{smoothedCurve} is \code{TRUE}.}

\item{returnFull}{Should the mean and median curves be returned (\code{TRUE}), or just the range value of where they first cross zero (\code{FALSE}).}

\item{cl}{Cluster object, or number of cluster instances to create. Defaults to no parallelization.}

\item{namestem}{Stem of names of columns of X corresponding to evaluated splines.
Defaults to \code{""}, meaning names of the form \code{1}, \code{2}, ...}

\item{inds}{Indices of observations to use for computation. Passed to \code{\link{computeS}}.}

\item{verbose}{Control printing of a df counter to console.}

\item{span}{Passed to \code{\link{fitLoess}}. If too small, then can lead to unstable loess estimates. Only needed when \code{smoothedCurve} is \code{TRUE}.}

\item{D}{Distance matrix for coordinates.}
}
\value{
The effective bandwidth for each value of \code{df}. If \code{returnFull = FALSE}, then this is a vector of the same length as \code{df}. If \code{returnFull = TRUE} and \code{smoothedCurve = TRUE}, this is a list that additionally contains values of the pointwise median and mean of the smoothed curves.
}
\description{
Calculates the effective range for a spline basis matrix.
}
\details{
Using the given spline basis and the inputted coordinates, the effective bandwidth is computed for the given degrees of freedom. This is accomplished by computing a distance matrix from the coordinates and a smoothing matrix from the basis.
Setting \code{smoothedCurve = TRUE} (see Keller and Szpiro, 2020, for details), for each column of smoothing weights, a LOESS curve is fit to the smoothing weights as a function of the distances, and the distance where the curve first crosses zero is obtained.
Setting \code{smoothedCurve = FALSE} (see Rainey and Keller, 2024, for details), for each column of smoothing weights, the smallest distance that corresponds with the first negative smoothing weight is obtained.
Then, for both procedures, the median of the obtained distances is reported as the effective bandwidth.

The columns of \code{X} are selected by name, and so are assumed to have a numeric value in the column name that indicates the spline number. For example, the columns containing the first three splines should be "1", "2", and "3". IF there is a fixed character prefix, that can be supplied via \code{namestem}. For example, if the columns are "s1", "s2", "s3", then set \code{namestem="s"}.
}
\examples{
M <- 16
tprs_df <- 10
si <- seq(0, 1, length=M+1)[-(M+1)]
gridcoords <- expand.grid(x=si, y=si)
tprsX <- computeTPRS(coords = gridcoords, maxdf = tprs_df+1)
compute_effective_range(X=tprsX, coords=gridcoords, df=3:10, smoothedCurve=FALSE)


xloc <- runif(n=100, min=0, max=10)
X <- splines::ns(x=xloc, df=4, intercept=TRUE)
colnames(X) <- paste0("s", 1:ncol(X))
xplot <- 0:10
compute_effective_range(X=X, coords=as.matrix(xloc), df=2:4, newd=xplot,
                        namestem="s", smoothedCurve = TRUE)

}
\references{
Keller and Szpiro (2020). Selecting a scale for spatial confounding adjustment. Journal of the Royal Statistical Society, Series A  https://doi.org/10.1111/rssa.12556.

Rainey and Keller (2024). spconfShiny: An R Shiny application for calculating the spatial scale of smoothing splines for point data. PLOS ONE https://doi.org/10.1371/journal.pone.0311440
}
\seealso{
\code{\link{compute_lowCurve}}
}
