% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotAIC}
\alias{plotAIC}
\title{Plots the AIC across model specifications.}
\usage{
plotAIC(sca_data, title = "", showIndex = TRUE, plotVars = TRUE)
}
\arguments{
\item{sca_data}{A data frame returned by `sca()` containing model estimates
from the specification curve analysis.}

\item{title}{A string to use as the plot title. Defaults to an empty string,
`""`.}

\item{showIndex}{A boolean indicating whether to label the model index on the
the x-axis. Defaults to `TRUE`.}

\item{plotVars}{A boolean indicating whether to include a panel on the plot
showing which variables are present in each model. Defaults
to `TRUE`.}
}
\value{
If `plotVars = TRUE` returns a grid grob (i.e. the output of a call
        to `grid.draw`). If `plotVars =  FALSE` returns a ggplot object.
}
\description{
plotAIC() plots the Akaike information criterion across model specifications.
Only available for nonlinear regression models.
}
\examples{
plotAIC(sca_data = sca(y = "Salnty", x = "T_degC",
                       controls = c("ChlorA", "O2Sat"),
                       data = bottles, progressBar = TRUE, parallel = FALSE),
                     title = "AIC");
plotAIC(sca_data = sca(y = "Salnty", x = "T_degC",
                       controls = c("ChlorA*O2Sat"),
                       data = bottles, progressBar = FALSE,
                       parallel = FALSE),
                       showIndex = FALSE, plotVars = FALSE);
plotAIC(sca_data = sca(y = "Salnty", x = "T_degC",
                         controls = c("ChlorA*NO3uM", "O2Sat*NO3uM"),
                         data = bottles,
                         progressBar = TRUE, parallel = TRUE, workers = 2));
}
