% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tajima.K.R
\name{tajima.K}
\alias{tajima.K}
\title{Calculate Tajima's K index of divergence}
\usage{
tajima.K(DNAbin, prop = TRUE)
}
\arguments{
\item{DNAbin}{An object of class `DNAbin'.}

\item{prop}{Logical. Should the function report the number of substitutions
per nucleotide? Default of TRUE.}
}
\value{
A vector of length 1. If \code{prop = FALSE}, the mean number of
substitutions between any two sequences is returned. If \code{prop = TRUE}
(the default), this number is returned as the mean number of substitutions
per nucleotide (i.e. the above divided by the length of the sequences).
}
\description{
Calculates Tajima's K index of divergence.
}
\examples{

data(anoteropsis)
tajima.K(anoteropsis)
tajima.K(anoteropsis, prop = FALSE)

}
\references{
Tajima, F. (1983). Evolutionary relationship of DNA sequences in
finite populations. _Genetics_ *105*, 437-460.
}
\seealso{
\code{\link[ape]{dist.dna}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Utilities}
