% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/follow.R
\name{follow_artists_or_users}
\alias{follow_artists_or_users}
\title{Add Current User as Follower Artists or Other Users}
\usage{
follow_artists_or_users(
  type,
  ids = NULL,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{type}{Required. The ID type: either \code{"artist"} or \code{"user"}.}

\item{ids}{Optional. A character vector of the artist or the user
\href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify IDs}. For example: \code{ids = c("74ASZWbe4lXaubB36ztrGX", "08td7MxkoHQkXnWAYD8d6Q")}. A maximum of 50 IDs can be sent in one request.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service.
See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. Modifying the list of artists or users the current user follows requires authorization of the \code{user-follow-modify} scope. See \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}.}
}
\value{
The response from the Spotify Web API on the \code{PUT} request, with a meaningful
error message if the operation was not successful.
}
\description{
Add the current user as a follower of one or more artists or other Spotify users.
}
