% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery.curve.R
\name{discovery.curve}
\alias{discovery.curve}
\title{Discovery Curve}
\usage{
discovery.curve(
  f,
  f0.func,
  max.x = sum(f * 1:length(f)),
  n.pts = 100,
  ci = 0.95,
  plot = TRUE,
  ...
)
}
\arguments{
\item{f}{a vector of species frequencies where \code{f[i]} is the number of 
species represented by only \code{i} samples.}

\item{f0.func}{function to use to calculate \code{\link{f0}}.}

\item{max.x}{the maximum number of samples to calculate the curve for. 
Defaults to the sample size of \code{f}.}

\item{n.pts}{number of points between 0 and \code{max.x} to estimate.}

\item{ci}{size of the confidence interval (0.5:1).}

\item{plot}{plot the curve?}

\item{...}{other arguments to \code{f0.func}.}
}
\value{
a list with:
\item{f.stats}{a named vector from \code{f0.func}.}
\item{curve}{a \code{data.frame} defining the rarefaction and 
extrapolation curves (specified in the \code{section} column), and columns 
providing the lower (\code{lci}) and upper (\code{uci}).}
}
\description{
Calculate the components of a species discovery curve.
}
\examples{
data(osa.old.growth)
f <- expand.freqs(osa.old.growth)
d <- discovery.curve(f, f0.func = Chao1, max.x = 1200)

print(str(d))

}
\references{
Colwell, R.K., A. Chao, N.J. Gotelli, S.-Y. Lin, C.X. Mao, 
  R.L. Chazdon, and J.T. Longino. 2012. Models and estimators linking 
  individual-based and sample-based rarefaction, extrapolation and 
  comparison of assemblages. Journal of Plant Ecology 5(1):3-21.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
