% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict.cv.sprinter}
\alias{predict.cv.sprinter}
\title{Calculate prediction from a \code{cv.sprinter} object.}
\usage{
\method{predict}{cv.sprinter}(object, newdata, ...)
}
\arguments{
\item{object}{a fitted \code{cv.sprinter} object.}

\item{newdata}{a design matrix of all the \code{p} main effects of some new observations of which predictions are to be made.}

\item{...}{additional argument (not used here, only for S3 generic/method consistency)}
}
\value{
The prediction of \code{newdata} by the cv.sprinter fit \code{object}.
}
\description{
Calculate prediction from a \code{cv.sprinter} object.
}
\examples{
n <- 100
p <- 200
x <- matrix(rnorm(n * p), n, p)
y <- x[, 1] + 2 * x[, 2] - 3 * x[, 1] * x[, 2] + rnorm(n)
mod <- cv.sprinter(x = x, y = y)
fitted <- predict(mod, newdata = x)

}
