% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sample_normal.R
\name{draw_sample_normal}
\alias{draw_sample_normal}
\title{Draw Samples from a Normal Distribution}
\usage{
draw_sample_normal(k_groups, f, max_n, sd = NULL, sample_ratio = NULL)
}
\arguments{
\item{k_groups}{number of groups (levels of factor_A)}

\item{f}{Cohen's f. The simulated effect size.}

\item{max_n}{sample size for the groups (total sample size = max_n*k_groups)}

\item{sd}{vector of standard deviations of the groups. Default value is 1 for each group.}

\item{sample_ratio}{vector of sample ratios between th groups. Default value is 1 for each group.}
}
\value{
returns a data.frame with the columns y (observations) and x (factor_A).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Draws exemplary samples with a certain effect size for the sequential one-oway ANOVA or the sequential t-test, see Steinhilber et al. (2023) \url{doi:10.31234/osf.io/m64ne}
}
\examples{
set.seed(333)

data <- sprtt::draw_sample_normal(
  k_groups = 2,
  f = 0.20,
  max_n = 2
)
data

data <- sprtt::draw_sample_normal(
  k_groups = 4,
  f = 0,
  max_n = 2,
  sd = c(1, 2, 1, 8)
)
data

data <- sprtt::draw_sample_normal(
  k_groups = 3,
  f = 0.40,
  max_n = 2,
  sd = c(1, 0.8, 1),
  sample_ratio = c(1, 2, 3)
)
data
}
