% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_connected.R
\name{is_connected}
\alias{is_connected}
\alias{not_connected}
\title{Test whether a database is connected}
\usage{
is_connected(conn_name)

not_connected(conn_name)
}
\arguments{
\item{conn_name}{Character. The name of a connection (run \code{\link[=connection_info]{connection_info()}}
for options)}
}
\value{
Logical, or NULL if \code{conn_name} does not identify exactly 1
connection
}
\description{
Test whether a database is connected
}
\examples{
library(sqlhelper)

connect(
  system.file("examples/sqlhelper_db_conf.yml",
              package="sqlhelper")
)
connection_info()

is_connected("simple_sqlite")
is_connected("foo")
DBI::dbDisconnect(live_connection("simple_sqlite"))
is_connected("simple_sqlite")
not_connected("simple_sqlite")
disconnect()
is_connected("simple_sqlite")
not_connected("simple_sqlite")
}
