% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ssddata.R
\name{get_ssddata}
\alias{get_ssddata}
\title{Get SSD dataset}
\usage{
get_ssddata(
  dataset_name,
  filter_val = NULL,
  use_gmmean = TRUE,
  spp_vec = c("Species", "Genus"),
  conc = "Conc"
)
}
\arguments{
\item{dataset_name}{The name (chr) of the desired dataset in ssddata.}

\item{filter_val}{A character string,
indicating the filter to be applied (value)
(colname) and which column it applies to, separated by "_".
Must be in the form colname_value.}

\item{use_gmmean}{Logical indicating if a geometric mean should be applied.}

\item{spp_vec}{The group_by columns to use for grouping
data and applying a geometric mean.}

\item{conc}{The name of the concentration (x data) column.}
}
\value{
The data.frame for dataset_name with any applied groupings and summary.
}
\description{
Retrieves a specific SSD dataset,
filtering and groups by species and applies a geometric
mean in the case of duplicate records.
}
\examples{
get_ssddata("ccme_boron")
}
