% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssrm.logmer.R
\name{ssrm.logmer}
\alias{ssrm.logmer}
\title{Sample Size Determination for Longitudinal Designs with Binary Outcome}
\usage{
ssrm.logmer(nt = NULL, Xd = NULL, betap = NULL, var.ri = NULL,
  var.rs = NULL, cov.is = NULL, ratio = NULL, xi1 = NULL, xi2 = NULL,
  ...)
}
\arguments{
\item{nt}{number of time-points.}

\item{Xd}{design column for the slope of time (monotonic function of time).}

\item{betap}{vector of beta parameters (b0=Intercept, b1=slope of time for control,
b3=group difference at time 0 between treatment and control groups, 
b4=main parameter of interest which captures difference between the slope parameters of 
treatment and control groups).}

\item{var.ri}{variance of random intercept.}

\item{var.rs}{variance of random slope.}

\item{cov.is}{covariance of intercept and slope.}

\item{ratio}{proportion of subjects in the control group out of the total sample.}

\item{xi1}{attrition vector of the control group. The elements of attrition vector should sum to 1.}

\item{xi2}{attrition vector of the treatment group. The elements of attrition vector should sum to 1.}

\item{...}{optional arguments \code{alpha}, \code{power}, \code{tail}, \code{num.quad}.}
}
\value{
results
}
\description{
Provides the necessary sample size for a longitudinal study with binary outcome in 
order to attain a pre-specified power while strictly maintaining the Type I error rate.
The sample size computation requires the user to define a column of design matrix 
relating to the slope of time as a monotonic function of time, such as linear, log, 
sqrt etc., along with the respective beta parameters. The underlying model is assumed 
to be a two-level logistic mixed-effects regression model with random intercept and/or 
slope of time to account for within-subject correlations and between-subject variability.
Gaussian quadrature is used to compute the marginal likelihood integrals and to evaluate 
Fisher Information matrix.
}
\details{
Attrition vector: This package allows for the specification of different attrition
vectors for the control and treatment group. The element of attrition vector should
sum to 1.
}
\examples{
ssrm.logmer(nt=4,Xd=c(0,1,2,3),betap=c(1,0,0.1,0.3),var.ri=0.5,
            ratio=0.5,xi1=c(0,0,0,1),xi2=c(0.1,0.1,0.2,0.6))
ssrm.logmer(nt=4,Xd=c(0,1,2,3),betap=c(1,0,0.1,0.3),var.ri=0.5,
            var.rs=0.25,cov.is=0.1,power=0.90,tail=1,alpha=0.025)
}
\references{
Kapur K, Bhaumik R, Charlene Tang X, Hur K, Reda DJ, Bhaumik DK (2014) <doi:10.1002/sim.6203>.
Sample size determination for longitudinal designs with binary response. Stat Med 33(22):3781-3800.
}
