% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_non_inferiority.R
\name{sim_power_ni_normal}
\alias{sim_power_ni_normal}
\title{Empirical Power for Non-Inferiority (Normal Outcomes)}
\usage{
sim_power_ni_normal(
  nsim,
  npergroup,
  ntest,
  ni_limit,
  test_req,
  test_opt,
  sd,
  corr = 0,
  t_level = 0.95,
  conf.level = 0.95
)
}
\arguments{
\item{nsim}{Integer. Number of simulations to perform.}

\item{npergroup}{Integer. Number of observations per group.}

\item{ntest}{Integer. Number of tests (outcomes) to compare.}

\item{ni_limit}{Numeric. Limit to declare non-inferiority. Can be a scalar or vector of length \code{ntest}.}

\item{test_req}{Integer. Number of required tests that must show non-inferiority (first \code{test_req} tests).}

\item{test_opt}{Integer. Number of optional tests that must also show non-inferiority from the remaining tests.}

\item{sd}{Numeric. Standard deviation(s) of the outcomes. Scalar or vector of length \code{ntest}.}

\item{corr}{Numeric. Correlation between the tests. Scalar (common correlation), or vector of length \code{ntest*(ntest-1)/2}.}

\item{t_level}{Numeric. Confidence level used for the t-tests (e.g., 0.95 for 95\% CI).scalar or vector of length \code{ntest}.}

\item{conf.level}{Numeric. Confidence level for the empirical power estimate}
}
\value{
An S3 object of class \code{empirical_power_result}, which contains
the estimated empirical power and its confidence interval. The object can
be printed, formatted, or further processed using associated S3 methods.
See also \code{\link{empirical_power_result}}.
}
\description{
Estimates empirical power to declare non-inferiority between two groups across multiple outcomes using
t-tests. Simulates normally distributed data under the null (no difference) and applies
non-inferiority rules based on user-defined required and optional tests.
}
\details{
A test is considered non-inferior if the lower bound of its confidence interval is greater
than the specified non-inferiority limit. Overall non-inferiority is declared if all
\code{test_req} and at least \code{test_opt} of the remaining tests are non-inferior.
}
\note{
If only one test is used, correlation is ignored.

Use correlation 0 for independent outcomes

When using a correlation vector, it must match the number of test pairs:
\code{ntest*(ntest-1)/2}, in this order: (1,2), (1,3), ..., (1,ntest), (2,3), ..., (ntest-1,ntest).

The covariance matrix is derived from the correlation matrix and the standard deviations.

For example: with \code{ntest = 3} and \code{corr = c(0.2, 0.3, 0.4)}, the resulting correlation matrix is:\tabular{llll}{
    \tab [,1] \tab [,2] \tab [,3] \cr
   [1, ] \tab 1 \tab 0.2 \tab 0.3 \cr
   [2, ] \tab 0.2. \tab 1 \tab 0.4 \cr
   [3, ] \tab 0.3. \tab 0.4 \tab 1 \cr
}
}
\examples{
sim_power_ni_normal(
  nsim = 1000,
  npergroup = 250,
  ntest = 7,
  ni_limit = log10(2/3),
  test_req = 2,
  test_opt = 3,
  sd = 0.4,
  corr = 0,
  t_level = 0.05
)
}
\seealso{
\code{\link{empirical_power_result}}
}
