% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_best_normal.R
\name{ss_best_normal}
\alias{ss_best_normal}
\title{Sample Size for Selecting the Best Treatment in a Normal Response (Indifference-Zone)}
\usage{
ss_best_normal(power, dif, sd, ngroups, seed = NULL)
}
\arguments{
\item{power}{Numeric. Desired probability of correctly selecting the best group.}

\item{dif}{Numeric. Indifferent-zone. Minimum difference that is considered meaningful.}

\item{sd}{Numeric. Common standard deviation of the response variable.}

\item{ngroups}{Integer. Number of groups (treatments) being compared.}

\item{seed}{Optional. Integer seed to use in the internal call to \code{multz()}.}
}
\value{
Integer. Sample size required per group to achieve the specified power.
}
\description{
Calculates the minimum common sample size per group needed to achieve a specified
probability (power) of correctly selecting the best group using the
indifference-zone approach. This method assumes normally distributed responses with
a known and common standard deviation.
}
\details{
The indifference-zone approach guarantees that the probability of correct selection
is at least \code{power}, assuming the best group's mean exceeds the others by at
least \code{dif}. The calculation is based on Bechhofer's Procedure Nb.
}
\note{
The function uses the quantile function \code{multz()}, which computes critical values
for the selection procedure. This implementation assumes equal variances and independent samples.
}
\examples{
ss_best_normal( power = 0.8, dif = 0.5, sd = 1, ngroups = 3)

}
\references{
Bechhofer, R.E., Santner, T.J., & Goldsman, D.M. (1995).
\emph{Design and Analysis of Experiments for Statistical Selection, Screening, and Multiple Comparisons.}
Wiley Series in Probability and Statistics. ISBN: 0-471-57427-9.
}
