% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_best_binomial.R
\name{wcs_power_best_binomial}
\alias{wcs_power_best_binomial}
\title{Worst‐Case Scenario Power for the Best Binomial Group}
\usage{
wcs_power_best_binomial(dif, ngroups, npergroup)
}
\arguments{
\item{dif}{Numeric. Indifference zone specification (difference threshold).}

\item{ngroups}{Integer. Number of groups to compare.}

\item{npergroup}{Integer. Number of subjects per group.}
}
\value{
A named list with components:
\describe{
\item{p1}{Numeric. Probability in the best group that yields the minimum power.}
\item{minimum_power}{Numeric. The minimum power achieved at \code{p1}.}
}
}
\description{
Searches for the probability in the best‐performing group that yields the lowest statistical power,
given an indifference zone specification, a number of groups, and a number of subjects per group.
}
\details{
Defines an internal function \code{fx} that wraps \code{\link{power_best_binomial}}
with the supplied parameters, then uses \code{\link[stats]{optimize}} over the interval [0,1]
to find the probability \code{p1} that minimizes the resulting power.
}
\examples{
wcs_power_best_binomial(dif = 0.1, ngroups = 3, npergroup = 50)

}
\seealso{
\code{\link{power_best_binomial}}, \code{\link[stats]{optimize}}
}
