% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staccuracy.R
\name{sa_diff}
\alias{sa_diff}
\title{Statistical tests for the differences between standardized accuracies (staccuracies)}
\usage{
sa_diff(
  actual,
  preds,
  ...,
  na.rm = FALSE,
  sa = NULL,
  pct = c(0.01, 0.02, 0.03, 0.04, 0.05),
  boot_alpha = 0.05,
  boot_it = 1000,
  seed = 0
)
}
\arguments{
\item{actual}{numeric vector. The actual (true) labels.}

\item{preds}{named list of at least two numeric vectors. Each element is a vector of the same length as actual with predictions for each row corresponding to each element of actual. The names of the list elements should be the names of the models that produced each respective prediction; these names will be used to distinguish the results.}

\item{...}{not used. Forces explicit naming of subsequent arguments.}

\item{na.rm}{See documentation for \code{\link[=staccuracy]{staccuracy()}}}

\item{sa}{list of functions. Each element is the unquoted name of a valid staccuracy function (see \code{\link[=staccuracy]{staccuracy()}} for the required function signature.) If an element is named, the name will be displayed as the value of the \code{sa} column of the result. Otherwise, the function name will be displayed. If NULL (default), staccuracy functions will be automatically selected based on the datatypes of actual and \code{preds}.}

\item{pct}{numeric with values from (0, 1). The percentage values on which the difference in staccuracies will be tested.}

\item{boot_alpha}{numeric(1) from 0 to 1. Alpha for percentile-based confidence interval range for the bootstrapped means; the bootstrap confidence intervals will be the lowest and highest \code{(1 - 0.05) / 2} percentiles. For example, if \code{boot_alpha = 0.05} (default), the intervals will be at the 2.5 and 97.5 percentiles.}

\item{boot_it}{positive integer(1). The number of bootstrap iterations.}

\item{seed}{integer(1). Random seed for the bootstrap sampling. Supply this between runs to assure identical results.}
}
\value{
tibble with staccuracy difference results:
\itemize{
\item \code{staccuracy}: name of staccuracy measure
\item \code{pred}: Each named element (model name) in the input \code{preds}. The row values give the staccuracy for that prediction. When \code{pred} is \code{NA}, the row represents the difference between prediction staccuracies (\code{diff}) instead of  staccuracies themselves.
\item \code{diff}: When \code{diff} takes the form 'model1-model2', then the row values give the difference in staccuracies between two named elements (model names) in the input \code{preds}. When \code{diff} is \code{NA}, the row instead represents the staccuracy of a specific model prediction (\code{pred}).
\item \code{lo}, \code{mean}, \code{hi}: The lower bound, mean, and upper bound of the bootstrapped staccuracy. The lower and upper bounds are confidence intervals specified by the input \code{boot_alpha}.
\item \code{p__}: p-values that the difference in staccuracies are at least the specified percentage amount or greater.  E.g., for the default input \code{pct = c(0.01, 0.02, 0.03, 0.04, 0.05)}, these columns would be \code{p01}, \code{p02}, \code{p03}, \code{p04}, and  \code{p05}. As they apply only to differences between staccuracies, they are provided only for \code{diff} rows and are \code{NA} for \code{pred} rows. As an example of their meaning, if the \code{mean} difference for 'model1-model2' is 0.0832 with \code{p01} of 0.012 and \code{p02} of 0.035, then 1.2\% of bootstrapped staccuracies had a model1 - model2 difference of less than 0.01 and 3.5\% were less than 0.02. (That is, 98.8\% of differences were greater than 0.01 and 96.5\% were greater than 0.02.)
}
}
\description{
Because the distribution of staccuracies is uncertain (and indeed, different staccuracies likely have different distributions), bootstrapping is used to empirically estimate the distributions and calculate the p-values. See the return value description for details on what the function provides.
}
\examples{
lm_attitude_all <- lm(rating ~ ., data = attitude)
lm_attitude__a <- lm(rating ~ . - advance, data = attitude)
lm_attitude__c <- lm(rating ~ . - complaints, data = attitude)

sdf <- sa_diff(
  attitude$rating,
  list(
    all = predict(lm_attitude_all),
    madv = predict(lm_attitude__a),
    mcmp = predict(lm_attitude__c)
  ),
  boot_it = 10
)
sdf

}
